/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SpatialJoinNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;

public class SchedulingOrderVisitor {
    public static List<PlanNodeId> scheduleOrder(PlanNode root) {
        ImmutableList.Builder schedulingOrder = ImmutableList.builder();
        root.accept((PlanVisitor)new Visitor(), arg_0 -> ((ImmutableList.Builder)schedulingOrder).add(arg_0));
        return schedulingOrder.build();
    }

    private SchedulingOrderVisitor() {
    }

    private static class Visitor
    extends InternalPlanVisitor<Void, Consumer<PlanNodeId>> {
        private Visitor() {
        }

        public Void visitPlan(PlanNode node, Consumer<PlanNodeId> schedulingOrder) {
            for (PlanNode source : node.getSources()) {
                source.accept((PlanVisitor)this, schedulingOrder);
            }
            return null;
        }

        public Void visitJoin(JoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getRight().accept((PlanVisitor)this, schedulingOrder);
            node.getLeft().accept((PlanVisitor)this, schedulingOrder);
            return null;
        }

        public Void visitSemiJoin(SemiJoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getFilteringSource().accept((PlanVisitor)this, schedulingOrder);
            node.getSource().accept((PlanVisitor)this, schedulingOrder);
            return null;
        }

        public Void visitSpatialJoin(SpatialJoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getRight().accept((PlanVisitor)this, schedulingOrder);
            node.getLeft().accept((PlanVisitor)this, schedulingOrder);
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getIndexSource().accept((PlanVisitor)this, schedulingOrder);
            node.getProbeSource().accept((PlanVisitor)this, schedulingOrder);
            return null;
        }

        public Void visitTableScan(TableScanNode node, Consumer<PlanNodeId> schedulingOrder) {
            schedulingOrder.accept(node.getId());
            return null;
        }
    }
}

