/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Query;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class SqlPlannerContext {
    private int leafNodesInLogicalPlan;
    private final SqlToRowExpressionTranslator.Context translatorContext;
    private final CteInfo cteInfo;

    public SqlPlannerContext(int leafNodesInLogicalPlan) {
        this.leafNodesInLogicalPlan = leafNodesInLogicalPlan;
        this.translatorContext = new SqlToRowExpressionTranslator.Context();
        this.cteInfo = new CteInfo();
    }

    public CteInfo getCteInfo() {
        return this.cteInfo;
    }

    public SqlToRowExpressionTranslator.Context getTranslatorContext() {
        return this.translatorContext;
    }

    public void incrementLeafNodes(Session session) {
        ++this.leafNodesInLogicalPlan;
        if (SystemSessionProperties.isLeafNodeLimitEnabled(session) && this.leafNodesInLogicalPlan > SystemSessionProperties.getMaxLeafNodesInPlan(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_PLAN_NODE_LIMIT, String.format("Number of leaf nodes in logical plan exceeds threshold %s set in max_leaf_nodes_in_plan", SystemSessionProperties.getMaxLeafNodesInPlan(session)));
        }
    }

    public class CteInfo {
        @VisibleForTesting
        public static final String delimiter = "_*%$_";
        private int prefix;
        private final Map<NodeRef<Query>, String> cteQueryUniqueIdMap = new HashMap<NodeRef<Query>, String>();

        public String normalize(NodeRef<Query> queryNodeRef, String cteName) {
            if (this.cteQueryUniqueIdMap.containsKey(queryNodeRef)) {
                return this.cteQueryUniqueIdMap.get(queryNodeRef) + delimiter + cteName;
            }
            String identityString = String.valueOf(this.prefix++);
            this.cteQueryUniqueIdMap.put(queryNodeRef, identityString);
            return identityString + delimiter + cteName;
        }
    }
}

