/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.EnumLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class TranslationMap {
    private final RelationPlan rewriteBase;
    private final Analysis analysis;
    private final Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap;
    private final VariableReferenceExpression[] fieldVariables;
    private final Map<Expression, VariableReferenceExpression> expressionToVariables = new HashMap<Expression, VariableReferenceExpression>();
    private final Map<Expression, Expression> expressionToExpressions = new HashMap<Expression, Expression>();

    public TranslationMap(RelationPlan rewriteBase, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap) {
        this.rewriteBase = Objects.requireNonNull(rewriteBase, "rewriteBase is null");
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.lambdaDeclarationToVariableMap = Objects.requireNonNull(lambdaDeclarationToVariableMap, "lambdaDeclarationToVariableMap is null");
        this.fieldVariables = new VariableReferenceExpression[rewriteBase.getFieldMappings().size()];
    }

    public RelationPlan getRelationPlan() {
        return this.rewriteBase;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> getLambdaDeclarationToVariableMap() {
        return this.lambdaDeclarationToVariableMap;
    }

    public void setFieldMappings(List<VariableReferenceExpression> variables) {
        Preconditions.checkArgument((variables.size() == this.fieldVariables.length ? 1 : 0) != 0, (String)"size of variables list (%s) doesn't match number of expected fields (%s)", (int)variables.size(), (int)this.fieldVariables.length);
        for (int i = 0; i < variables.size(); ++i) {
            this.fieldVariables[i] = variables.get(i);
        }
    }

    public void copyMappingsFrom(TranslationMap other) {
        Preconditions.checkArgument((other.fieldVariables.length == this.fieldVariables.length ? 1 : 0) != 0, (String)"number of fields in other (%s) doesn't match number of expected fields (%s)", (int)other.fieldVariables.length, (int)this.fieldVariables.length);
        this.expressionToVariables.putAll(other.expressionToVariables);
        this.expressionToExpressions.putAll(other.expressionToExpressions);
        System.arraycopy(other.fieldVariables, 0, this.fieldVariables, 0, other.fieldVariables.length);
    }

    public void putExpressionMappingsFrom(TranslationMap other) {
        this.expressionToVariables.putAll(other.expressionToVariables);
        this.expressionToExpressions.putAll(other.expressionToExpressions);
    }

    public Expression rewrite(final Expression expression) {
        Expression mapped = this.translateNamesToSymbols(expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Boolean>(){

            public Expression rewriteExpression(Expression node, Boolean context, ExpressionTreeRewriter<Boolean> treeRewriter) {
                if (!(!TranslationMap.this.expressionToVariables.containsKey(node) || context.equals(Boolean.TRUE) && ExpressionTreeUtils.isConstant(node))) {
                    return new SymbolReference(expression.getLocation(), ((VariableReferenceExpression)TranslationMap.this.expressionToVariables.get(node)).getName());
                }
                Expression translated = TranslationMap.this.expressionToExpressions.getOrDefault(node, node);
                return treeRewriter.defaultRewrite(translated, (Object)context);
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Boolean context, ExpressionTreeRewriter<Boolean> treeRewriter) {
                Expression result = super.rewriteLambdaExpression(node, (Object)true, treeRewriter);
                return result;
            }
        }, (Expression)mapped, (Object)false);
    }

    public void put(Expression expression, VariableReferenceExpression variable) {
        if (expression instanceof FieldReference) {
            int fieldIndex = ((FieldReference)expression).getFieldIndex();
            this.fieldVariables[fieldIndex] = variable;
            this.expressionToVariables.put((Expression)new SymbolReference(expression.getLocation(), this.rewriteBase.getVariable(fieldIndex).getName()), variable);
            return;
        }
        Expression translated = this.translateNamesToSymbols(expression);
        this.expressionToVariables.put(translated, variable);
        this.rewriteBase.getScope().tryResolveField(expression).filter(ResolvedField::isLocal).ifPresent(field -> {
            this.fieldVariables[field.getHierarchyFieldIndex()] = variable;
        });
    }

    public boolean containsSymbol(Expression expression) {
        if (expression instanceof FieldReference) {
            int field = ((FieldReference)expression).getFieldIndex();
            return this.fieldVariables[field] != null;
        }
        Expression translated = this.translateNamesToSymbols(expression);
        return this.expressionToVariables.containsKey(translated);
    }

    public VariableReferenceExpression get(Expression expression) {
        if (expression instanceof FieldReference) {
            int field = ((FieldReference)expression).getFieldIndex();
            Preconditions.checkArgument((this.fieldVariables[field] != null ? 1 : 0) != 0, (String)"No mapping for field: %s", (int)field);
            return this.fieldVariables[field];
        }
        Expression translated = this.translateNamesToSymbols(expression);
        if (!this.expressionToVariables.containsKey(translated)) {
            Preconditions.checkArgument((boolean)this.expressionToExpressions.containsKey(translated), (String)"No mapping for expression: %s", (Object)expression);
            return this.get(this.expressionToExpressions.get(translated));
        }
        return this.expressionToVariables.get(translated);
    }

    public void put(Expression expression, Expression rewritten) {
        this.expressionToExpressions.put(this.translateNamesToSymbols(expression), rewritten);
    }

    private Expression translateNamesToSymbols(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                return this.coerceIfNecessary(node, rewrittenExpression);
            }

            public Expression rewriteFieldReference(FieldReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                VariableReferenceExpression variable = TranslationMap.this.rewriteBase.getVariable(node.getFieldIndex());
                Preconditions.checkState((variable != null ? 1 : 0) != 0, (String)"No variable mapping for node '%s' (%s)", (Object)node, (int)node.getFieldIndex());
                return new SymbolReference(ExpressionTreeUtils.getNodeLocation(variable.getSourceLocation()), variable.getName());
            }

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                LambdaArgumentDeclaration referencedLambdaArgumentDeclaration = TranslationMap.this.analysis.getLambdaArgumentReference(node);
                if (referencedLambdaArgumentDeclaration != null) {
                    VariableReferenceExpression variable = (VariableReferenceExpression)TranslationMap.this.lambdaDeclarationToVariableMap.get(NodeRef.of((Node)referencedLambdaArgumentDeclaration));
                    return this.coerceIfNecessary((Expression)node, (Expression)ExpressionTreeUtils.createSymbolReference(variable));
                }
                return this.rewriteExpressionWithResolvedName((Expression)node);
            }

            private Expression rewriteExpressionWithResolvedName(Expression node) {
                return TranslationMap.this.getVariable(TranslationMap.this.rewriteBase, node).map(variable -> this.coerceIfNecessary(node, (Expression)ExpressionTreeUtils.createSymbolReference(variable))).orElseGet(() -> this.coerceIfNecessary(node, node));
            }

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                if (TranslationMap.this.analysis.isColumnReference((Expression)node)) {
                    Optional resolvedField = TranslationMap.this.rewriteBase.getScope().tryResolveField((Expression)node);
                    if (resolvedField.isPresent() && ((ResolvedField)resolvedField.get()).isLocal()) {
                        return TranslationMap.this.getVariable(TranslationMap.this.rewriteBase, (Expression)node).map(variable -> this.coerceIfNecessary((Expression)node, (Expression)ExpressionTreeUtils.createSymbolReference(variable))).orElseThrow(() -> new IllegalStateException("No symbol mapping for node " + node));
                    }
                    return node;
                }
                Type nodeType = TranslationMap.this.analysis.getType((Expression)node);
                Type baseType = TranslationMap.this.analysis.getType(node.getBase());
                if (TypeUtils.isEnumType((Type)baseType) && TypeUtils.isEnumType((Type)nodeType)) {
                    return new EnumLiteral(node.getLocation(), nodeType.getTypeSignature().toString(), ExpressionTreeUtils.resolveEnumLiteral(node, nodeType));
                }
                return this.rewriteExpression((Expression)node, context, treeRewriter);
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Preconditions.checkState((TranslationMap.this.analysis.getCoercion((Expression)node) == null ? 1 : 0) != 0, (Object)"cannot coerce a lambda expression");
                ImmutableList.Builder newArguments = ImmutableList.builder();
                for (LambdaArgumentDeclaration argument : node.getArguments()) {
                    VariableReferenceExpression variable = (VariableReferenceExpression)TranslationMap.this.lambdaDeclarationToVariableMap.get(NodeRef.of((Node)argument));
                    newArguments.add((Object)new LambdaArgumentDeclaration(new Identifier(argument.getLocation(), variable.getName())));
                }
                Expression rewrittenBody = treeRewriter.rewrite(node.getBody(), null);
                return new LambdaExpression(node.getLocation(), (List)newArguments.build(), rewrittenBody);
            }

            public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Preconditions.checkState((TranslationMap.this.analysis.getParameters().size() > node.getPosition() ? 1 : 0) != 0, (Object)"Too few parameter values");
                return this.coerceIfNecessary((Expression)node, (Expression)TranslationMap.this.analysis.getParameters().get(NodeRef.of((Node)node)));
            }

            private Expression coerceIfNecessary(Expression original, Expression rewritten) {
                Type coercion = TranslationMap.this.analysis.getCoercion(original);
                if (coercion != null) {
                    rewritten = new Cast(original.getLocation(), rewritten, coercion.getTypeSignature().toString(), false, TranslationMap.this.analysis.isTypeOnlyCoercion(original));
                }
                return rewritten;
            }
        }, (Expression)expression, null);
    }

    private Optional<VariableReferenceExpression> getVariable(RelationPlan plan, Expression expression) {
        if (!this.analysis.isColumnReference(expression)) {
            return Optional.empty();
        }
        return plan.getScope().tryResolveField(expression).filter(ResolvedField::isLocal).map(field -> Objects.requireNonNull(plan.getFieldMappings().get(field.getHierarchyFieldIndex())));
    }
}

