/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class EquivalenceClassProperty {
    private final Map<RowExpression, RowExpression> equivalenceClassHeads;
    private final Map<RowExpression, List<RowExpression>> equivalenceClasses;

    public EquivalenceClassProperty() {
        this((Map<RowExpression, RowExpression>)ImmutableMap.of(), (Map<RowExpression, List<RowExpression>>)ImmutableMap.of());
    }

    public EquivalenceClassProperty(EquivalenceClassProperty equivalenceClassProperty) {
        this(equivalenceClassProperty.getEquivalenceClassHeads(), equivalenceClassProperty.getEquivalenceClasses());
    }

    public EquivalenceClassProperty(Map<RowExpression, RowExpression> equivalenceClassHeads, Map<RowExpression, List<RowExpression>> equivalenceClasses) {
        this.equivalenceClassHeads = ImmutableMap.copyOf(Objects.requireNonNull(equivalenceClassHeads, "equivalenceClassHeads is null"));
        this.equivalenceClasses = ImmutableMap.copyOf(Objects.requireNonNull(equivalenceClasses, "equivalenceClasses is null"));
    }

    public Map<RowExpression, List<RowExpression>> getEquivalenceClasses() {
        return this.equivalenceClasses;
    }

    public Map<RowExpression, RowExpression> getEquivalenceClassHeads() {
        return this.equivalenceClassHeads;
    }

    public boolean isMoreGeneralThan(EquivalenceClassProperty otherEquivalenceClassProperty) {
        if (this.equivalenceClasses.isEmpty() && otherEquivalenceClassProperty.equivalenceClasses.isEmpty()) {
            return true;
        }
        if (this.equivalenceClasses.isEmpty() || otherEquivalenceClassProperty.equivalenceClasses.isEmpty()) {
            return false;
        }
        ImmutableList eqClassSets = (ImmutableList)this.equivalenceClasses.entrySet().stream().map(e1 -> new ImmutableSet.Builder().add((Object)((RowExpression)e1.getKey())).addAll((Iterable)e1.getValue()).build()).collect(ImmutableList.toImmutableList());
        return otherEquivalenceClassProperty.equivalenceClasses.entrySet().stream().allMatch(e -> {
            HashSet<RowExpression> otherEqClass = new HashSet<RowExpression>();
            otherEqClass.add((RowExpression)e.getKey());
            otherEqClass.addAll((Collection)e.getValue());
            return eqClassSets.stream().anyMatch(eqClassSet -> eqClassSet.containsAll((Collection)otherEqClass));
        });
    }

    public RowExpression getEquivalenceClassHead(RowExpression expression) {
        Preconditions.checkArgument((expression instanceof VariableReferenceExpression || expression instanceof ConstantExpression ? 1 : 0) != 0, (Object)("Row expression is of type " + expression.getClass().getSimpleName() + ", must be a VariableReferenceExpression or a ConstantExpression."));
        return this.equivalenceClassHeads.getOrDefault(expression, expression);
    }

    public List<RowExpression> getEquivalenceClasses(RowExpression head) {
        Preconditions.checkArgument((head instanceof VariableReferenceExpression || head instanceof ConstantExpression ? 1 : 0) != 0, (Object)("Row expression is of type " + head.getClass().getSimpleName() + ", must be a VariableReferenceExpression or a ConstantExpression."));
        return this.equivalenceClasses.getOrDefault(head, new ArrayList());
    }

    public EquivalenceClassProperty combineWith(EquivalenceClassProperty equivalenceClassProperty) {
        EquivalenceClassProperty newEquivalenceClassProperty = new EquivalenceClassProperty(this.equivalenceClassHeads, this.equivalenceClasses);
        for (Map.Entry<RowExpression, List<RowExpression>> equivalenceClass : equivalenceClassProperty.equivalenceClasses.entrySet()) {
            for (RowExpression member : equivalenceClass.getValue()) {
                newEquivalenceClassProperty = newEquivalenceClassProperty.combineWith(equivalenceClass.getKey(), member);
            }
        }
        return newEquivalenceClassProperty;
    }

    public EquivalenceClassProperty addPredicate(RowExpression predicate, FunctionResolution functionResolution) {
        EquivalenceClassProperty newEquivalenceClassProperty = this;
        Set callExprs = (Set)LogicalRowExpressions.extractConjuncts((RowExpression)predicate).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(e -> EquivalenceClassProperty.isVariableEqualVariableOrConstant(functionResolution, (RowExpression)e)).collect(ImmutableSet.toImmutableSet());
        for (CallExpression callExpr : callExprs) {
            Preconditions.checkState((callExpr.getArguments().size() == 2 ? 1 : 0) != 0, (Object)"callExpr must have 2 arguments");
            newEquivalenceClassProperty = newEquivalenceClassProperty.combineWith((RowExpression)callExpr.getArguments().get(0), (RowExpression)callExpr.getArguments().get(1));
        }
        return newEquivalenceClassProperty;
    }

    private static boolean isVariableEqualVariableOrConstant(FunctionResolution functionResolution, RowExpression expression) {
        if (expression instanceof CallExpression && functionResolution.isEqualFunction(((CallExpression)expression).getFunctionHandle()) && ((CallExpression)expression).getArguments().size() == 2) {
            RowExpression e1 = (RowExpression)((CallExpression)expression).getArguments().get(0);
            RowExpression e2 = (RowExpression)((CallExpression)expression).getArguments().get(1);
            return e1 instanceof VariableReferenceExpression && (e2 instanceof VariableReferenceExpression || e2 instanceof ConstantExpression) || e2 instanceof VariableReferenceExpression && e1 instanceof ConstantExpression;
        }
        return false;
    }

    public EquivalenceClassProperty combineWith(RowExpression firstExpression, RowExpression secondExpression) {
        RowExpression head2;
        RowExpression head1 = this.getEquivalenceClassHead(firstExpression);
        if (head1 == (head2 = this.getEquivalenceClassHead(secondExpression))) {
            return this;
        }
        List<RowExpression> head1Class = this.getEquivalenceClasses(head1);
        List<RowExpression> head2Class = this.getEquivalenceClasses(head2);
        RowExpression newHead = EquivalenceClassProperty.pickNewHead(head1, head2);
        ImmutableList.Builder mergedEquivalenceClasses = ImmutableList.builder();
        mergedEquivalenceClasses.addAll(head1Class).addAll(head2Class);
        if (newHead == head1) {
            return this.combineClasses(head1, (List<RowExpression>)mergedEquivalenceClasses.add((Object)head2).build(), head2, head2Class);
        }
        return this.combineClasses(head2, (List<RowExpression>)mergedEquivalenceClasses.add((Object)head1).build(), head1, head1Class);
    }

    private static RowExpression pickNewHead(RowExpression head1, RowExpression head2) {
        if (head2 instanceof ConstantExpression) {
            return head2;
        }
        return head1;
    }

    private EquivalenceClassProperty combineClasses(RowExpression head, List<RowExpression> headClass, RowExpression headOfOtherEqClass, List<RowExpression> otherEqClass) {
        HashMap<RowExpression, RowExpression> newEquivalenceClassHeads = new HashMap<RowExpression, RowExpression>();
        newEquivalenceClassHeads.putAll(this.getEquivalenceClassHeads());
        newEquivalenceClassHeads.put(headOfOtherEqClass, head);
        otherEqClass.stream().forEach(expression -> newEquivalenceClassHeads.put((RowExpression)expression, head));
        Map<RowExpression, List<RowExpression>> newEquivalenceClasses = this.equivalenceClasses.entrySet().stream().filter(e -> e.getKey() != headOfOtherEqClass).collect(Collectors.toMap(e -> (RowExpression)e.getKey(), e -> (List)e.getValue()));
        if (!this.equivalenceClasses.containsKey(head)) {
            newEquivalenceClasses.put(head, headClass);
        } else {
            List<RowExpression> currExprs = this.equivalenceClasses.get(head);
            ImmutableList.Builder newExprs = ImmutableList.builder();
            newExprs.addAll(currExprs);
            for (RowExpression rowExpr : headClass) {
                if (currExprs.contains(rowExpr)) continue;
                newExprs.add((Object)rowExpr);
            }
            newEquivalenceClasses.put(head, (List<RowExpression>)newExprs.build());
        }
        return new EquivalenceClassProperty(newEquivalenceClassHeads, newEquivalenceClasses);
    }

    public EquivalenceClassProperty project(Map<VariableReferenceExpression, VariableReferenceExpression> inverseVariableMappings) {
        EquivalenceClassProperty projectedEquivalenceClassProperty = new EquivalenceClassProperty();
        for (Map.Entry<RowExpression, List<RowExpression>> entry : this.equivalenceClasses.entrySet()) {
            RowExpression currentHead;
            ArrayList<RowExpression> projectedMembers = new ArrayList<RowExpression>();
            for (RowExpression member : entry.getValue()) {
                RowExpression projectedMember;
                if (!inverseVariableMappings.containsKey(member) || projectedMembers.contains(projectedMember = (RowExpression)inverseVariableMappings.get(member))) continue;
                projectedMembers.add(projectedMember);
            }
            if (projectedMembers.isEmpty()) continue;
            RowExpression projectedHead = currentHead = entry.getKey();
            if (currentHead instanceof VariableReferenceExpression) {
                if (inverseVariableMappings.containsKey(currentHead)) {
                    projectedHead = (RowExpression)inverseVariableMappings.get(currentHead);
                    projectedMembers.remove(projectedHead);
                } else {
                    projectedHead = (RowExpression)projectedMembers.get(0);
                    projectedMembers.remove(0);
                }
            }
            RowExpression finalProjectedHead = projectedHead;
            for (RowExpression rowExpr : projectedMembers) {
                projectedEquivalenceClassProperty = projectedEquivalenceClassProperty.combineWith(finalProjectedHead, rowExpr);
            }
        }
        return projectedEquivalenceClassProperty;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("EquivalenceClassHeads", (Object)String.join((CharSequence)",", (Iterable)this.equivalenceClassHeads.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(ImmutableList.toImmutableList()))).add("EquivalenceClasses", (Object)String.join((CharSequence)",", (Iterable)this.equivalenceClasses.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(ImmutableList.toImmutableList()))).toString();
    }
}

