/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneSemiJoinColumns
extends ProjectOffPushDownRule<SemiJoinNode> {
    public PruneSemiJoinColumns() {
        super(Patterns.semiJoin());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, SemiJoinNode semiJoinNode, Set<VariableReferenceExpression> referencedOutputs) {
        if (!referencedOutputs.contains(semiJoinNode.getSemiJoinOutput())) {
            return Optional.of(semiJoinNode.getSource());
        }
        Set requiredSourceInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream().filter(variable -> !variable.equals((Object)semiJoinNode.getSemiJoinOutput())), Stream.of(semiJoinNode.getSourceJoinVariable()), semiJoinNode.getSourceHashVariable().map(Stream::of).orElseGet(Stream::empty)}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictOutputs(idAllocator, semiJoinNode.getSource(), requiredSourceInputs).map(newSource -> semiJoinNode.replaceChildren((List)ImmutableList.of((Object)newSource, (Object)semiJoinNode.getFilteringSource())));
    }
}

