/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.optimizations.WindowNodeUtil;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneWindowColumns
extends ProjectOffPushDownRule<WindowNode> {
    public PruneWindowColumns() {
        super(Patterns.window());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, WindowNode windowNode, Set<VariableReferenceExpression> referencedOutputs) {
        Map referencedFunctions = Maps.filterKeys((Map)windowNode.getWindowFunctions(), referencedOutputs::contains);
        if (referencedFunctions.isEmpty()) {
            return Optional.of(windowNode.getSource());
        }
        ImmutableSet.Builder referencedInputs = ImmutableSet.builder().addAll(windowNode.getSource().getOutputVariables().stream().filter(referencedOutputs::contains).iterator()).addAll((Iterable)windowNode.getPartitionBy());
        windowNode.getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderByVariables().forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0)));
        windowNode.getHashVariable().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        for (WindowNode.Function windowFunction : referencedFunctions.values()) {
            referencedInputs.addAll(WindowNodeUtil.extractWindowFunctionUniqueVariables(windowFunction));
            windowFunction.getFrame().getStartValue().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
            windowFunction.getFrame().getEndValue().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
            windowFunction.getFrame().getSortKeyCoercedForFrameStartComparison().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
            windowFunction.getFrame().getSortKeyCoercedForFrameEndComparison().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        }
        WindowNode prunedWindowNode = new WindowNode(windowNode.getSourceLocation(), windowNode.getId(), Util.restrictOutputs(idAllocator, windowNode.getSource(), (Set<VariableReferenceExpression>)referencedInputs.build()).orElse(windowNode.getSource()), windowNode.getSpecification(), referencedFunctions, windowNode.getHashVariable(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix());
        if (prunedWindowNode.getOutputVariables().size() == windowNode.getOutputVariables().size()) {
            return Optional.empty();
        }
        return Optional.of(prunedWindowNode);
    }
}

