/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RowExpressionRewriteRuleSet;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public class RemoveMapCastRule
extends RowExpressionRewriteRuleSet {
    public RemoveMapCastRule(FunctionAndTypeManager functionAndTypeManager) {
        super(new Rewriter(functionAndTypeManager));
    }

    @Override
    public boolean isRewriterEnabled(Session session) {
        return SystemSessionProperties.isRemoveMapCastEnabled(session);
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.filterRowExpressionRewriteRule(), this.projectRowExpressionRewriteRule());
    }

    private static class Rewriter
    implements RowExpressionRewriteRuleSet.PlanRowExpressionRewriter {
        private final RemoveMapCastRewriter removeMapCastRewriter;

        public Rewriter(FunctionAndTypeManager functionAndTypeManager) {
            Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
            this.removeMapCastRewriter = new RemoveMapCastRewriter(functionAndTypeManager);
        }

        @Override
        public RowExpression rewrite(RowExpression expression, Rule.Context context) {
            return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)this.removeMapCastRewriter, (RowExpression)expression);
        }
    }

    private static class RemoveMapCastRewriter
    extends RowExpressionRewriter<Void> {
        private final FunctionAndTypeManager functionAndTypeManager;
        private final FunctionResolution functionResolution;

        private RemoveMapCastRewriter(FunctionAndTypeManager functionAndTypeManager) {
            this.functionAndTypeManager = functionAndTypeManager;
            this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
        }

        public RowExpression rewriteCall(CallExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
            Type toValueType;
            Type toKeyType;
            Type fromValueType;
            CallExpression castExpression;
            RowExpression castInput;
            Type fromKeyType;
            if ((this.functionResolution.isSubscriptFunction(node.getFunctionHandle()) || this.functionResolution.isElementAtFunction(node.getFunctionHandle())) && node.getArguments().get(0) instanceof CallExpression && this.functionResolution.isCastFunction(((CallExpression)node.getArguments().get(0)).getFunctionHandle()) && ((RowExpression)((CallExpression)node.getArguments().get(0)).getArguments().get(0)).getType() instanceof MapType && RemoveMapCastRewriter.canRemoveMapCast(fromKeyType = ((MapType)(castInput = (RowExpression)(castExpression = (CallExpression)node.getArguments().get(0)).getArguments().get(0)).getType()).getKeyType(), fromValueType = ((MapType)castInput.getType()).getValueType(), toKeyType = ((MapType)castExpression.getType()).getKeyType(), toValueType = ((MapType)castExpression.getType()).getValueType(), ((RowExpression)node.getArguments().get(1)).getType())) {
                if (this.functionResolution.isSubscriptFunction(node.getFunctionHandle())) {
                    RowExpression newIndex = Expressions.castToInteger(this.functionAndTypeManager, (RowExpression)node.getArguments().get(1));
                    return Expressions.call(OperatorType.SUBSCRIPT.name(), this.functionResolution.subscriptFunction(castInput.getType(), newIndex.getType()), node.getType(), castInput, newIndex);
                }
                RowExpression newIndex = Expressions.tryCast(this.functionAndTypeManager, (RowExpression)node.getArguments().get(1), (Type)IntegerType.INTEGER);
                return Expressions.call(this.functionAndTypeManager, "element_at", node.getType(), castInput, newIndex);
            }
            return null;
        }

        private static boolean canRemoveMapCast(Type fromKeyType, Type fromValueType, Type toKeyType, Type toValueType, Type indexType) {
            return fromValueType.equals(toValueType) && fromKeyType.equals(IntegerType.INTEGER) && toKeyType.equals(BigintType.BIGINT) && indexType.equals(BigintType.BIGINT);
        }
    }
}

