/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class ScaledWriterRule
implements Rule<TableWriterNode> {
    private String statsSource;

    @Override
    public Pattern<TableWriterNode> getPattern() {
        return Patterns.tableWriterNode().matching(x -> !x.getTaskCountIfScaledWriter().isPresent());
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.useHistoryBasedScaledWriters(session);
    }

    @Override
    public boolean isCostBased(Session session) {
        return true;
    }

    @Override
    public String getStatsSource() {
        return this.statsSource;
    }

    @Override
    public Rule.Result apply(TableWriterNode node, Captures captures, Rule.Context context) {
        double taskNumber = context.getStatsProvider().getStats((PlanNode)node).getTableWriterNodeStatsEstimate().getTaskCountIfScaledWriter();
        this.statsSource = context.getStatsProvider().getStats((PlanNode)node).getSourceInfo().getSourceInfoName();
        if (Double.isNaN(taskNumber)) {
            return Rule.Result.empty();
        }
        int initialTaskNumber = (int)Math.ceil(taskNumber / 2.0);
        Preconditions.checkState((initialTaskNumber > 0 ? 1 : 0) != 0, (Object)"taskCountIfScaledWriter should be at least 1");
        return Rule.Result.ofPlanNode((PlanNode)new TableWriterNode(node.getSourceLocation(), node.getId(), node.getStatsEquivalentPlanNode(), node.getSource(), node.getTarget(), node.getRowCountVariable(), node.getFragmentVariable(), node.getTableCommitContextVariable(), node.getColumns(), node.getColumnNames(), node.getNotNullColumnVariables(), node.getTablePartitioningScheme(), node.getStatisticsAggregation(), Optional.of(initialTaskNumber), node.getIsTemporaryTableWriter()));
    }
}

