/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class SimplifySortWithConstantInput
implements Rule<SortNode> {
    private static final Capture<ProjectNode> SOURCE = Capture.newCapture();
    private static final Pattern<SortNode> PATTERN = Patterns.sort().with(Patterns.source().matching(Patterns.project().matching(project -> project.getAssignments().getMap().values().stream().anyMatch(x -> x instanceof ConstantExpression)).capturedAs(SOURCE)));

    @Override
    public Pattern<SortNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isRewriteExpressionWithConstantEnabled(session);
    }

    @Override
    public Rule.Result apply(SortNode node, Captures captures, Rule.Context context) {
        ProjectNode projectNode = (ProjectNode)captures.get(SOURCE);
        Map constantExpressionMap = (Map)projectNode.getAssignments().entrySet().stream().filter(x -> x.getValue() instanceof ConstantExpression).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, x -> (ConstantExpression)x.getValue()));
        if (node.getOrderingScheme().getOrderByVariables().stream().anyMatch(x -> constantExpressionMap.containsKey(x))) {
            List newOrderBy = (List)node.getOrderingScheme().getOrderBy().stream().filter(x -> !constantExpressionMap.containsKey(x.getVariable())).collect(ImmutableList.toImmutableList());
            if (newOrderBy.isEmpty()) {
                return Rule.Result.ofPlanNode((PlanNode)projectNode);
            }
            OrderingScheme orderExcludeConstantVariable = new OrderingScheme(newOrderBy);
            return Rule.Result.ofPlanNode((PlanNode)new SortNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)projectNode, orderExcludeConstantVariable, node.isPartial(), node.getPartitionBy()));
        }
        return Rule.Result.empty();
    }
}

