/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanNodeDecorrelator;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedLateralJoinToJoin
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin().with(Pattern.nonEmpty(Patterns.LateralJoin.correlation()));
    private final LogicalRowExpressions logicalRowExpressions;

    public TransformCorrelatedLateralJoinToJoin(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()), (FunctionMetadataManager)functionAndTypeManager);
    }

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = lateralJoinNode.getSubquery();
        PlanNodeDecorrelator planNodeDecorrelator = new PlanNodeDecorrelator(context.getIdAllocator(), context.getVariableAllocator(), context.getLookup(), this.logicalRowExpressions);
        Optional<PlanNodeDecorrelator.DecorrelatedNode> decorrelatedNodeOptional = planNodeDecorrelator.decorrelateFilters(subquery, lateralJoinNode.getCorrelation());
        return decorrelatedNodeOptional.map(decorrelatedNode -> Rule.Result.ofPlanNode((PlanNode)new JoinNode(lateralJoinNode.getSourceLocation(), context.getIdAllocator().getNextId(), lateralJoinNode.getType().toJoinNodeType(), lateralJoinNode.getInput(), decorrelatedNode.getNode(), (List)ImmutableList.of(), lateralJoinNode.getOutputVariables(), decorrelatedNode.getCorrelatedPredicates(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of()))).orElseGet(Rule.Result::empty);
    }
}

