/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.relation.InSubqueryExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Optional;

public class TransformUncorrelatedInPredicateSubqueryToSemiJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().with(Pattern.empty(Patterns.Apply.correlation()));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        if (applyNode.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        RowExpression expression = (RowExpression)Iterables.getOnlyElement((Iterable)applyNode.getSubqueryAssignments().getExpressions());
        if (!(expression instanceof InSubqueryExpression)) {
            return Rule.Result.empty();
        }
        InSubqueryExpression inPredicate = (InSubqueryExpression)expression;
        VariableReferenceExpression semiJoinVariable = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)applyNode.getSubqueryAssignments().getVariables());
        SemiJoinNode replacement = new SemiJoinNode(applyNode.getSourceLocation(), context.getIdAllocator().getNextId(), applyNode.getInput(), applyNode.getSubquery(), inPredicate.getValue(), inPredicate.getSubquery(), semiJoinVariable, Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        return Rule.Result.ofPlanNode((PlanNode)replacement);
    }
}

