/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class JoinPrefilter
implements PlanOptimizer {
    private final Metadata metadata;
    private boolean isEnabledForTesting;

    public JoinPrefilter(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.isJoinPrefilterEnabled(session);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.isEnabled(session)) {
            Rewriter rewriter = new Rewriter(session, this.metadata, idAllocator, variableAllocator, this.metadata.getFunctionAndTypeManager());
            PlanNode rewritten = SimplePlanRewriter.rewriteWith(rewriter, plan, null);
            return PlanOptimizerResult.optimizerResult(rewritten, rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Session session;
        private final Metadata metadata;
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private final FunctionAndTypeManager functionAndTypeManager;
        private boolean planChanged;

        private Rewriter(Session session, Metadata metadata, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, FunctionAndTypeManager functionAndTypeManager) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "functionAndTypeManager is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "idAllocator is null");
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        }

        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = node.getLeft();
            PlanNode right = node.getRight();
            PlanNode rewrittenLeft = Rewriter.rewriteWith(this, left);
            PlanNode rewrittenRight = Rewriter.rewriteWith(this, right);
            List equiJoinClause = node.getCriteria();
            if ((node.getType() == JoinType.LEFT || node.getType() == JoinType.INNER) && PlannerUtils.isScanFilterProject(rewrittenLeft) && !node.getCriteria().isEmpty()) {
                List leftKeyList = (List)equiJoinClause.stream().map(EquiJoinClause::getLeft).collect(ImmutableList.toImmutableList());
                List rightKeyList = (List)equiJoinClause.stream().map(EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
                Preconditions.checkState((boolean)IntStream.range(0, leftKeyList.size()).boxed().allMatch(i -> ((VariableReferenceExpression)leftKeyList.get((int)i)).getType().equals(((VariableReferenceExpression)rightKeyList.get((int)i)).getType())));
                boolean hashJoinKey = leftKeyList.size() > 1 || ((VariableReferenceExpression)leftKeyList.get(0)).getType().equals(VarcharType.VARCHAR) || ((VariableReferenceExpression)leftKeyList.get(0)).getType() instanceof VarcharType;
                HashMap<VariableReferenceExpression, VariableReferenceExpression> leftVarMap = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
                PlanNode leftKeys = PlannerUtils.clonePlanNode(rewrittenLeft, this.session, this.metadata, this.idAllocator, leftKeyList, leftVarMap);
                ImmutableList.Builder expressionsToProject = ImmutableList.builder();
                if (hashJoinKey) {
                    RowExpression hashExpression = this.getVariableHash(leftKeyList);
                    expressionsToProject.add((Object)hashExpression);
                } else {
                    expressionsToProject.add((Object)((RowExpression)leftVarMap.get(leftKeyList.get(0))));
                }
                PlanNode projectNode = PlannerUtils.projectExpressions(leftKeys, this.idAllocator, this.variableAllocator, (List<? extends RowExpression>)expressionsToProject.build(), (List<VariableReferenceExpression>)ImmutableList.of());
                VariableReferenceExpression rightKeyToFilter = (VariableReferenceExpression)rightKeyList.get(0);
                if (hashJoinKey) {
                    RowExpression hashExpression = this.getVariableHash(rightKeyList);
                    rightKeyToFilter = this.variableAllocator.newVariable(hashExpression);
                    rewrittenRight = PlannerUtils.addProjections(rewrittenRight, this.idAllocator, (Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)rightKeyToFilter, (Object)hashExpression));
                }
                AggregationNode filteringSource = new AggregationNode(node.getLeft().getSourceLocation(), this.idAllocator.getNextId(), projectNode, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)projectNode.getOutputVariables()), projectNode.getOutputVariables(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
                filteringSource = PlannerUtils.projectExpressions((PlanNode)filteringSource, this.idAllocator, this.variableAllocator, (List<? extends RowExpression>)ImmutableList.of((Object)((VariableReferenceExpression)filteringSource.getOutputVariables().get(0))), (List<VariableReferenceExpression>)ImmutableList.of());
                VariableReferenceExpression semiJoinOutput = this.variableAllocator.newVariable("semiJoinOutput", (Type)BooleanType.BOOLEAN);
                SemiJoinNode semiJoinNode = new SemiJoinNode(node.getRight().getSourceLocation(), this.idAllocator.getNextId(), node.getStatsEquivalentPlanNode(), rewrittenRight, (PlanNode)filteringSource, rightKeyToFilter, (VariableReferenceExpression)filteringSource.getOutputVariables().get(0), semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
                rewrittenRight = new FilterNode(semiJoinNode.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)semiJoinNode, (RowExpression)semiJoinOutput);
                if (rewrittenRight.getOutputVariables().size() > node.getRight().getOutputVariables().size()) {
                    rewrittenRight = PlannerUtils.restrictOutput(rewrittenRight, this.idAllocator, node.getRight().getOutputVariables());
                }
            }
            if (rewrittenLeft != node.getLeft() || rewrittenRight != node.getRight()) {
                this.planChanged = true;
                return ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)ImmutableList.of((Object)rewrittenLeft, (Object)rewrittenRight));
            }
            return node;
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        private RowExpression getVariableHash(List<VariableReferenceExpression> inputVariables) {
            List hashExpressionList = (List)inputVariables.stream().map(keyVariable -> Expressions.callOperator(this.functionAndTypeManager.getFunctionAndTypeResolver(), OperatorType.XX_HASH_64, (Type)BigintType.BIGINT, new RowExpression[]{keyVariable})).collect(ImmutableList.toImmutableList());
            RowExpression hashExpression = (RowExpression)hashExpressionList.get(0);
            if (hashExpressionList.size() > 1) {
                hashExpression = PlannerUtils.orNullHashCode(hashExpression);
                for (int i = 1; i < hashExpressionList.size(); ++i) {
                    hashExpression = Expressions.call(this.functionAndTypeManager, "combine_hash", (Type)BigintType.BIGINT, hashExpression, PlannerUtils.orNullHashCode((RowExpression)hashExpressionList.get(i)));
                }
            }
            return hashExpression;
        }
    }
}

