/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TemporaryTableUtil;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PhysicalCteOptimizer
implements PlanOptimizer {
    private final Metadata metadata;

    public PhysicalCteOptimizer(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(warningCollector, "warningCollector is null");
        if (!SystemSessionProperties.isCteMaterializationApplicable(session)) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        PhysicalCteTransformerContext context = new PhysicalCteTransformerContext();
        CteProducerRewriter cteProducerRewriter = new CteProducerRewriter(session, idAllocator, variableAllocator);
        CteConsumerRewriter cteConsumerRewriter = new CteConsumerRewriter(session, idAllocator, variableAllocator);
        PlanNode producerReplaced = SimplePlanRewriter.rewriteWith(cteProducerRewriter, plan, context);
        PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(cteConsumerRewriter, producerReplaced, context);
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, cteConsumerRewriter.isPlanRewritten() || cteProducerRewriter.isPlanRewritten());
    }

    public static class PhysicalCteTransformerContext {
        private Map<String, TemporaryTableInfo> cteNameToTableInfo = new HashMap<String, TemporaryTableInfo>();

        public void put(String cteName, TemporaryTableInfo handle) {
            this.cteNameToTableInfo.put(cteName, handle);
        }

        public TemporaryTableInfo getTableInfo(String cteName) {
            return this.cteNameToTableInfo.get(cteName);
        }

        public static class TemporaryTableInfo {
            private final TableScanNode tableScanNode;
            private final List<VariableReferenceExpression> originalOutputVariables;

            public TemporaryTableInfo(TableScanNode tableScanNode, List<VariableReferenceExpression> originalOutputVariables) {
                this.tableScanNode = Objects.requireNonNull(tableScanNode, "tableScanNode must not be null");
                this.originalOutputVariables = Objects.requireNonNull(originalOutputVariables, "originalOutputVariables must not be null");
            }

            public List<VariableReferenceExpression> getOriginalOutputVariables() {
                return this.originalOutputVariables;
            }

            public TableScanNode getTableScanNode() {
                return this.tableScanNode;
            }
        }
    }

    public class CteProducerRewriter
    extends SimplePlanRewriter<PhysicalCteTransformerContext> {
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private final Session session;
        private boolean isPlanRewritten;

        public CteProducerRewriter(Session session, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
            this.session = Objects.requireNonNull(session, "session must not be null");
        }

        public PlanNode visitCteProducer(CteProducerNode node, SimplePlanRewriter.RewriteContext<PhysicalCteTransformerContext> context) {
            TableHandle temporaryTableHandle;
            this.isPlanRewritten = true;
            PlanNode actualSource = node.getSource();
            String partitioningProviderCatalog = SystemSessionProperties.getCtePartitioningProviderCatalog(this.session);
            Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap = TemporaryTableUtil.assignTemporaryTableColumnNames(actualSource.getOutputVariables());
            try {
                temporaryTableHandle = PhysicalCteOptimizer.this.metadata.createTemporaryTable(this.session, partitioningProviderCatalog, (List<ColumnMetadata>)ImmutableList.copyOf(variableToColumnMap.values()), Optional.empty());
                context.get().put(node.getCteId(), new PhysicalCteTransformerContext.TemporaryTableInfo(TemporaryTableUtil.createTemporaryTableScan(PhysicalCteOptimizer.this.metadata, this.session, this.idAllocator, node.getSourceLocation(), temporaryTableHandle, actualSource.getOutputVariables(), variableToColumnMap, Optional.empty(), Optional.of(node.getCteId())), node.getOutputVariables()));
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Temporary table cannot be created in catalog \"%s\": %s", partitioningProviderCatalog, e.getMessage()), (Throwable)e);
                }
                throw e;
            }
            return TemporaryTableUtil.createTemporaryTableWriteWithoutExchanges(PhysicalCteOptimizer.this.metadata, this.session, this.idAllocator, this.variableAllocator, actualSource, temporaryTableHandle, actualSource.getOutputVariables(), variableToColumnMap, node.getRowCountVariable(), Optional.of(node.getCteId()));
        }

        public boolean isPlanRewritten() {
            return this.isPlanRewritten;
        }
    }

    public class CteConsumerRewriter
    extends SimplePlanRewriter<PhysicalCteTransformerContext> {
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private final Session session;
        private boolean isPlanRewritten;

        public CteConsumerRewriter(Session session, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
            this.session = Objects.requireNonNull(session, "session must not be null");
        }

        public PlanNode visitCteConsumer(CteConsumerNode node, SimplePlanRewriter.RewriteContext<PhysicalCteTransformerContext> context) {
            this.isPlanRewritten = true;
            PhysicalCteTransformerContext.TemporaryTableInfo tableInfo = context.get().getTableInfo(node.getCteId());
            TableScanNode tempScan = tableInfo.getTableScanNode();
            ArrayList<VariableReferenceExpression> newOutputVariables = new ArrayList<VariableReferenceExpression>();
            HashMap<VariableReferenceExpression, ColumnHandle> newColumnAssignmentsMap = new HashMap<VariableReferenceExpression, ColumnHandle>();
            for (VariableReferenceExpression oldVariable : tempScan.getOutputVariables()) {
                VariableReferenceExpression newVariable = this.variableAllocator.newVariable(oldVariable);
                newOutputVariables.add(newVariable);
                newColumnAssignmentsMap.put(newVariable, (ColumnHandle)tempScan.getAssignments().get(oldVariable));
            }
            TableScanNode tableScanNode = new TableScanNode(Optional.empty(), this.idAllocator.getNextId(), tempScan.getTable(), newOutputVariables, newColumnAssignmentsMap, tempScan.getCurrentConstraint(), tempScan.getEnforcedConstraint(), tempScan.getCteMaterializationInfo());
            HashMap<VariableReferenceExpression, VariableReferenceExpression> intermediateReferenceMap = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            for (int i = 0; i < tempScan.getOutputVariables().size(); ++i) {
                intermediateReferenceMap.put((VariableReferenceExpression)tempScan.getOutputVariables().get(i), (VariableReferenceExpression)newOutputVariables.get(i));
            }
            Assignments.Builder assignments = Assignments.builder();
            for (int i = 0; i < tableInfo.getOriginalOutputVariables().size(); ++i) {
                assignments.put((VariableReferenceExpression)node.getOutputVariables().get(i), (RowExpression)intermediateReferenceMap.get(tableInfo.getOriginalOutputVariables().get(i)));
            }
            return new ProjectNode(Optional.empty(), this.idAllocator.getNextId(), Optional.empty(), (PlanNode)tableScanNode, assignments.build(), ProjectNode.Locality.LOCAL);
        }

        public boolean isPlanRewritten() {
            return this.isPlanRewritten;
        }
    }
}

