/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.util.Objects;

public final class QueryCardinalityUtil {
    private QueryCardinalityUtil() {
    }

    public static boolean isScalar(PlanNode node) {
        return QueryCardinalityUtil.isScalar(node, Lookup.noLookup());
    }

    public static boolean isScalar(PlanNode node, Lookup lookup) {
        return Range.singleton((Comparable)Long.valueOf(1L)).encloses(QueryCardinalityUtil.extractCardinality(node, lookup));
    }

    public static boolean isAtMostScalar(PlanNode node) {
        return QueryCardinalityUtil.isAtMostScalar(node, Lookup.noLookup());
    }

    public static boolean isAtMostScalar(PlanNode node, Lookup lookup) {
        return QueryCardinalityUtil.isAtMost(node, lookup, 1L);
    }

    public static boolean isAtMost(PlanNode node, Lookup lookup, long maxCardinality) {
        return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(maxCardinality)).encloses(QueryCardinalityUtil.extractCardinality(node, lookup));
    }

    public static Range<Long> extractCardinality(PlanNode node) {
        return QueryCardinalityUtil.extractCardinality(node, Lookup.noLookup());
    }

    public static Range<Long> extractCardinality(PlanNode node, Lookup lookup) {
        return (Range)node.accept((PlanVisitor)new CardinalityExtractorPlanVisitor(lookup), null);
    }

    private static final class CardinalityExtractorPlanVisitor
    extends InternalPlanVisitor<Range<Long>, Void> {
        private final Lookup lookup;

        public CardinalityExtractorPlanVisitor(Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        public Range<Long> visitPlan(PlanNode node, Void context) {
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitGroupReference(GroupReference node, Void context) {
            return (Range)this.lookup.resolve(node).accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Range<Long> visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return Range.singleton((Comparable)Long.valueOf(1L));
        }

        public Range<Long> visitAggregation(AggregationNode node, Void context) {
            if (!node.hasNonEmptyGroupingSet()) {
                return Range.singleton((Comparable)Long.valueOf(node.getGlobalGroupingSets().size()));
            }
            return Range.atLeast((Comparable)Long.valueOf(node.getGlobalGroupingSets().size()));
        }

        @Override
        public Range<Long> visitExchange(ExchangeNode node, Void context) {
            if (node.getSources().size() == 1) {
                return (Range)((PlanNode)Iterables.getOnlyElement(node.getSources())).accept((PlanVisitor)this, null);
            }
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        public Range<Long> visitProject(ProjectNode node, Void context) {
            return (Range)node.getSource().accept((PlanVisitor)this, null);
        }

        public Range<Long> visitFilter(FilterNode node, Void context) {
            Range sourceCardinalityRange = (Range)node.getSource().accept((PlanVisitor)this, null);
            if (sourceCardinalityRange.hasUpperBound()) {
                return Range.closed((Comparable)Long.valueOf(0L), (Comparable)((Long)sourceCardinalityRange.upperEndpoint()));
            }
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        public Range<Long> visitValues(ValuesNode node, Void context) {
            return Range.singleton((Comparable)Long.valueOf(node.getRows().size()));
        }

        @Override
        public Range<Long> visitOffset(OffsetNode node, Void context) {
            Range sourceCardinalityRange = (Range)node.getSource().accept((PlanVisitor)this, null);
            long lower = Math.max((Long)sourceCardinalityRange.lowerEndpoint() - node.getCount(), 0L);
            if (sourceCardinalityRange.hasUpperBound()) {
                return Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(Math.max((Long)sourceCardinalityRange.upperEndpoint() - node.getCount(), 0L)));
            }
            return Range.atLeast((Comparable)Long.valueOf(lower));
        }

        public Range<Long> visitLimit(LimitNode node, Void context) {
            Range sourceCardinalityRange = (Range)node.getSource().accept((PlanVisitor)this, null);
            long upper = node.getCount();
            if (sourceCardinalityRange.hasUpperBound()) {
                upper = Math.min((Long)sourceCardinalityRange.upperEndpoint(), node.getCount());
            }
            long lower = Math.min(upper, (Long)sourceCardinalityRange.lowerEndpoint());
            return Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(upper));
        }
    }
}

