/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.JoinNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RandomizeNullKeyInOuterJoin
implements PlanOptimizer {
    private final FunctionAndTypeManager functionAndTypeManager;
    private final StatsCalculator statsCalculator;
    private boolean isEnabledForTesting;

    public RandomizeNullKeyInOuterJoin(FunctionAndTypeManager functionAndTypeManager, StatsCalculator statsCalculator) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.getJoinDistributionType(session).canPartition() && !SystemSessionProperties.getRandomizeOuterJoinNullKeyStrategy(session).equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.DISABLED);
    }

    @Override
    public boolean isCostBased(Session session) {
        return SystemSessionProperties.getRandomizeOuterJoinNullKeyStrategy(session).equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.COST_BASED);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.isEnabled(session)) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, session, types);
            Rewriter rewriter = new Rewriter(session, this.functionAndTypeManager, idAllocator, variableAllocator, statsProvider);
            PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(rewriter, plan, new HashSet());
            return PlanOptimizerResult.optimizerResult(rewrittenPlan, rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Set<VariableReferenceExpression>> {
        private static final double NULL_BUILD_KEY_COUNT_THRESHOLD = 100000.0;
        private static final double NULL_PROBE_KEY_COUNT_THRESHOLD = 100000.0;
        private static final String LEFT_PREFIX = "l";
        private static final String RIGHT_PREFIX = "r";
        private final Session session;
        private final FunctionAndTypeManager functionAndTypeManager;
        private final PlanNodeIdAllocator planNodeIdAllocator;
        private final VariableAllocator planVariableAllocator;
        private final StatsProvider statsProvider;
        private final Map<String, Map<VariableReferenceExpression, VariableReferenceExpression>> keyToRandomKeyMap;
        private final FeaturesConfig.RandomizeOuterJoinNullKeyStrategy strategy;
        private boolean planChanged;

        private Rewriter(Session session, FunctionAndTypeManager functionAndTypeManager, PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator planVariableAllocator, StatsProvider statsProvider) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
            this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator is null");
            this.planVariableAllocator = Objects.requireNonNull(planVariableAllocator, "planVariableAllocator is null");
            this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
            this.keyToRandomKeyMap = new HashMap<String, Map<VariableReferenceExpression, VariableReferenceExpression>>();
            this.strategy = SystemSessionProperties.getRandomizeOuterJoinNullKeyStrategy(session);
        }

        private static boolean isSupportedType(VariableReferenceExpression variable) {
            return Stream.of(BigintType.BIGINT, DateType.DATE).anyMatch(x -> x.equals((Object)variable.getType())) || variable.getType() instanceof VarcharType;
        }

        private static boolean isPartitionedJoin(JoinNode joinNode) {
            return joinNode.getDistributionType().isPresent() && joinNode.getDistributionType().get() == JoinDistributionType.PARTITIONED;
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN)) {
                ImmutableMultimap.Builder renameAssignmentBuilder = ImmutableMultimap.builder();
                node.getAssignments().getMap().forEach((k, v) -> {
                    if (v instanceof VariableReferenceExpression) {
                        renameAssignmentBuilder.put((Object)((VariableReferenceExpression)v), k);
                    }
                });
                ImmutableMultimap renameAssignment = renameAssignmentBuilder.build();
                context.get().addAll((Collection)context.get().stream().flatMap(x -> renameAssignment.get(x).stream()).collect(ImmutableSet.toImmutableSet()));
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        public PlanNode visitJoin(JoinNode joinNode, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (joinNode.isCrossJoin()) {
                PlanNode rewrittenLeft = context.rewrite(joinNode.getLeft(), context.get());
                PlanNode rewrittenRight = context.rewrite(joinNode.getRight(), context.get());
                ImmutableSet inputVariables = ImmutableSet.builder().addAll((Iterable)rewrittenLeft.getOutputVariables()).addAll((Iterable)rewrittenRight.getOutputVariables()).build();
                Preconditions.checkState((boolean)inputVariables.containsAll(joinNode.getOutputVariables()));
                return new JoinNode(joinNode.getSourceLocation(), joinNode.getId(), joinNode.getStatsEquivalentPlanNode(), joinNode.getType(), rewrittenLeft, rewrittenRight, joinNode.getCriteria(), (List)inputVariables.stream().collect(ImmutableList.toImmutableList()), joinNode.getFilter(), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters());
            }
            if (Stream.of(JoinType.LEFT, JoinType.RIGHT, JoinType.FULL).noneMatch(joinType -> joinType.equals((Object)joinNode.getType())) || !Rewriter.isPartitionedJoin(joinNode)) {
                PlanNode result = context.defaultRewrite((PlanNode)joinNode, context.get());
                return result;
            }
            PlanNode rewrittenLeft = context.rewrite(joinNode.getLeft(), context.get());
            PlanNode rewrittenRight = context.rewrite(joinNode.getRight(), context.get());
            boolean enabledByCostModel = this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.COST_BASED) && this.hasNullSkew(this.statsProvider.getStats((PlanNode)joinNode).getJoinNodeStatsEstimate());
            List candidateEquiJoinClauses = (List)joinNode.getCriteria().stream().filter(x -> Rewriter.isSupportedType(x.getLeft()) && Rewriter.isSupportedType(x.getRight())).filter(x -> enabledByCostModel || this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.ALWAYS) || this.enabledForJoinKeyFromOuterJoin((Set)context.get(), (EquiJoinClause)x)).collect(ImmutableList.toImmutableList());
            if (candidateEquiJoinClauses.isEmpty()) {
                PlanNode result = ChildReplacer.replaceChildren((PlanNode)joinNode, (List<PlanNode>)ImmutableList.of((Object)rewrittenLeft, (Object)rewrittenRight));
                if (this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN)) {
                    Preconditions.checkState((boolean)(result instanceof JoinNode));
                    this.updateCandidates((JoinNode)result, context);
                }
                return result;
            }
            List leftJoinKeys = (List)candidateEquiJoinClauses.stream().map(x -> x.getLeft()).filter(x -> !this.isAlreadyRandomized(rewrittenLeft, (VariableReferenceExpression)x, LEFT_PREFIX)).collect(ImmutableList.toImmutableList());
            Map<VariableReferenceExpression, RowExpression> leftKeyRandomVariableMap = this.generateRandomKeyMap(leftJoinKeys, LEFT_PREFIX);
            List rightJoinKeys = (List)candidateEquiJoinClauses.stream().map(x -> x.getRight()).filter(x -> !this.isAlreadyRandomized(rewrittenRight, (VariableReferenceExpression)x, RIGHT_PREFIX)).collect(ImmutableList.toImmutableList());
            Map<VariableReferenceExpression, RowExpression> rightKeyRandomVariableMap = this.generateRandomKeyMap(rightJoinKeys, RIGHT_PREFIX);
            ImmutableList.Builder joinClauseBuilder = ImmutableList.builder();
            List rewrittenJoinClauses = (List)candidateEquiJoinClauses.stream().map(x -> new EquiJoinClause(this.keyToRandomKeyMap.get(LEFT_PREFIX).get(x.getLeft()), this.keyToRandomKeyMap.get(RIGHT_PREFIX).get(x.getRight()))).collect(ImmutableList.toImmutableList());
            joinClauseBuilder.addAll((Iterable)rewrittenJoinClauses);
            List unchangedJoinClauses = (List)joinNode.getCriteria().stream().filter(x -> !candidateEquiJoinClauses.contains(x)).collect(ImmutableList.toImmutableList());
            joinClauseBuilder.addAll((Iterable)unchangedJoinClauses);
            Map leftIsNullCheckExpression = (Map)candidateEquiJoinClauses.stream().filter(x -> x.getLeft().getType() instanceof VarcharType).map(x -> x.getLeft()).distinct().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{x})));
            Map leftIsNullCheckAssignment = (Map)leftIsNullCheckExpression.values().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> this.planVariableAllocator.newVariable(x)));
            Map rightIsNullCheckExpression = (Map)candidateEquiJoinClauses.stream().filter(x -> x.getRight().getType() instanceof VarcharType).map(x -> x.getRight()).distinct().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{x})));
            Map rightIsNullCheckAssignment = (Map)rightIsNullCheckExpression.values().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> this.planVariableAllocator.newVariable(x)));
            List isNullCheck = (List)candidateEquiJoinClauses.stream().filter(x -> x.getLeft().getType() instanceof VarcharType && x.getRight().getType() instanceof VarcharType).map(x -> new EquiJoinClause((VariableReferenceExpression)leftIsNullCheckAssignment.get(leftIsNullCheckExpression.get(x.getLeft())), (VariableReferenceExpression)rightIsNullCheckAssignment.get(rightIsNullCheckExpression.get(x.getRight())))).collect(ImmutableList.toImmutableList());
            joinClauseBuilder.addAll((Iterable)isNullCheck);
            Assignments.Builder leftAssignments = Assignments.builder();
            leftAssignments.putAll(leftKeyRandomVariableMap);
            leftAssignments.putAll((Map)rewrittenLeft.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
            leftAssignments.putAll((Map)leftIsNullCheckAssignment.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey)));
            Assignments.Builder rightAssignments = Assignments.builder();
            rightAssignments.putAll(rightKeyRandomVariableMap);
            rightAssignments.putAll((Map)rewrittenRight.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
            rightAssignments.putAll((Map)rightIsNullCheckAssignment.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey)));
            ProjectNode newLeft = new ProjectNode(rewrittenLeft.getSourceLocation(), this.planNodeIdAllocator.getNextId(), rewrittenLeft, leftAssignments.build(), ProjectNode.Locality.LOCAL);
            ProjectNode newRight = new ProjectNode(rewrittenRight.getSourceLocation(), this.planNodeIdAllocator.getNextId(), rewrittenRight, rightAssignments.build(), ProjectNode.Locality.LOCAL);
            ImmutableList.Builder joinOutputBuilder = ImmutableList.builder();
            joinOutputBuilder.addAll(leftKeyRandomVariableMap.keySet());
            joinOutputBuilder.addAll((Iterable)joinNode.getOutputVariables().stream().filter(x -> newLeft.getOutputVariables().contains(x)).collect(ImmutableList.toImmutableList()));
            joinOutputBuilder.addAll(rightKeyRandomVariableMap.keySet());
            joinOutputBuilder.addAll((Iterable)joinNode.getOutputVariables().stream().filter(x -> newRight.getOutputVariables().contains(x)).collect(ImmutableList.toImmutableList()));
            this.planChanged = true;
            JoinNode newJoinNode = new JoinNode(joinNode.getSourceLocation(), joinNode.getId(), joinNode.getStatsEquivalentPlanNode(), joinNode.getType(), (PlanNode)newLeft, (PlanNode)newRight, (List)joinClauseBuilder.build(), (List)joinOutputBuilder.build(), joinNode.getFilter(), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters());
            if (this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN)) {
                this.updateCandidates(newJoinNode, context);
            }
            return newJoinNode;
        }

        private boolean hasNullSkew(JoinNodeStatsEstimate joinEstimate) {
            boolean isValidEstimate = !Double.isNaN(joinEstimate.getJoinBuildKeyCount()) && !Double.isNaN(joinEstimate.getNullJoinBuildKeyCount()) && !Double.isNaN(joinEstimate.getJoinProbeKeyCount()) && !Double.isNaN(joinEstimate.getNullJoinProbeKeyCount());
            return isValidEstimate && (joinEstimate.getNullJoinBuildKeyCount() > 100000.0 && joinEstimate.getNullJoinBuildKeyCount() / joinEstimate.getJoinBuildKeyCount() > SystemSessionProperties.getRandomizeOuterJoinNullKeyNullRatioThreshold(this.session) || joinEstimate.getNullJoinProbeKeyCount() > 100000.0 && joinEstimate.getNullJoinProbeKeyCount() / joinEstimate.getJoinProbeKeyCount() > SystemSessionProperties.getRandomizeOuterJoinNullKeyNullRatioThreshold(this.session));
        }

        private RowExpression randomizeJoinKey(RowExpression keyExpression, String prefix) {
            int partitionCount = SystemSessionProperties.getHashPartitionCount(this.session);
            CallExpression randomNumber = Expressions.call(this.functionAndTypeManager, "random", (Type)BigintType.BIGINT, new RowExpression[]{Expressions.constant(partitionCount, (Type)BigintType.BIGINT)});
            CallExpression randomNumberVarchar = Expressions.call("CAST", this.functionAndTypeManager.lookupCast(CastType.CAST, randomNumber.getType(), (Type)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, new RowExpression[]{randomNumber});
            CallExpression concatExpression = Expressions.call(this.functionAndTypeManager, "concat", (Type)VarcharType.VARCHAR, (List<RowExpression>)ImmutableList.of((Object)Expressions.constant(Slices.utf8Slice((String)prefix), (Type)VarcharType.VARCHAR), (Object)randomNumberVarchar));
            RowExpression castToVarchar = keyExpression;
            if (!(keyExpression.getType() instanceof VarcharType)) {
                castToVarchar = Expressions.call("CAST", this.functionAndTypeManager.lookupCast(CastType.CAST, keyExpression.getType(), (Type)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, keyExpression);
            }
            return new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)castToVarchar, (Object)concatExpression));
        }

        private boolean isAlreadyRandomized(PlanNode source, VariableReferenceExpression joinKey, String prefix) {
            return this.keyToRandomKeyMap.containsKey(prefix) && this.keyToRandomKeyMap.get(prefix).containsKey(joinKey) && source.getOutputVariables().contains(this.keyToRandomKeyMap.get(prefix).get(joinKey));
        }

        private boolean enabledForJoinKeyFromOuterJoin(Set<VariableReferenceExpression> variablesFromOuterJoin, EquiJoinClause joinClause) {
            return this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN) && (variablesFromOuterJoin.contains(joinClause.getLeft()) || variablesFromOuterJoin.contains(joinClause.getRight()));
        }

        private Map<VariableReferenceExpression, RowExpression> generateRandomKeyMap(List<VariableReferenceExpression> joinKeys, String prefix) {
            List randomExpressions = (List)joinKeys.stream().map(x -> this.randomizeJoinKey((RowExpression)x, prefix)).collect(ImmutableList.toImmutableList());
            List randomVariable = (List)randomExpressions.stream().map(x -> this.planVariableAllocator.newVariable(x, RandomizeNullKeyInOuterJoin.class.getSimpleName())).collect(ImmutableList.toImmutableList());
            Preconditions.checkState((joinKeys.size() == randomVariable.size() ? 1 : 0) != 0);
            Map newKeyToRandomMap = (Map)IntStream.range(0, joinKeys.size()).boxed().collect(ImmutableMap.toImmutableMap(joinKeys::get, randomVariable::get));
            if (!this.keyToRandomKeyMap.containsKey(prefix)) {
                this.keyToRandomKeyMap.put(prefix, new HashMap());
            }
            this.keyToRandomKeyMap.get(prefix).putAll(newKeyToRandomMap);
            Map result = (Map)IntStream.range(0, randomVariable.size()).boxed().collect(ImmutableMap.toImmutableMap(randomVariable::get, randomExpressions::get));
            return result;
        }

        private void updateCandidates(JoinNode joinNode, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (joinNode.getType().equals((Object)JoinType.LEFT)) {
                context.get().addAll((Collection)joinNode.getOutputVariables().stream().filter(x -> joinNode.getRight().getOutputVariables().contains(x)).collect(ImmutableSet.toImmutableSet()));
            } else if (joinNode.getType().equals((Object)JoinType.RIGHT)) {
                context.get().addAll((Collection)joinNode.getOutputVariables().stream().filter(x -> joinNode.getLeft().getOutputVariables().contains(x)).collect(ImmutableSet.toImmutableSet()));
            } else {
                Preconditions.checkState((boolean)joinNode.getType().equals((Object)JoinType.FULL));
                context.get().addAll(joinNode.getOutputVariables());
            }
        }
    }
}

