/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SetOperationNodeUtils {
    private SetOperationNodeUtils() {
    }

    public static Map<VariableReferenceExpression, List<VariableReferenceExpression>> fromListMultimap(ListMultimap<VariableReferenceExpression, VariableReferenceExpression> outputsToInputs) {
        LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>> mapping = new LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>>();
        for (Map.Entry entry : outputsToInputs.entries()) {
            if (!mapping.containsKey(entry.getKey())) {
                ArrayList<VariableReferenceExpression> values = new ArrayList<VariableReferenceExpression>();
                values.add((VariableReferenceExpression)entry.getValue());
                mapping.put((VariableReferenceExpression)entry.getKey(), values);
                continue;
            }
            ((List)mapping.get(entry.getKey())).add((VariableReferenceExpression)entry.getValue());
        }
        return mapping;
    }

    public static Multimap<VariableReferenceExpression, VariableReferenceExpression> outputMap(UnionNode node, int sourceIndex) {
        return FluentIterable.from((Iterable)node.getOutputVariables()).toMap(output -> (VariableReferenceExpression)((List)node.getVariableMapping().get(output)).get(sourceIndex)).asMultimap().inverse();
    }
}

