/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;

public class SimplifyPlanWithEmptyInput
implements PlanOptimizer {
    private boolean isEnabledForTesting;

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.isSimplifyPlanWithEmptyInputEnabled(session);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.isEnabled(session)) {
            Rewriter rewriter = new Rewriter(idAllocator, session);
            PlanNode rewrittenNode = SimplePlanRewriter.rewriteWith(rewriter, plan);
            return PlanOptimizerResult.optimizerResult(rewrittenNode, rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private boolean planChanged;
        private final Session session;

        public Rewriter(PlanNodeIdAllocator idAllocator, Session session) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.planChanged = false;
            this.session = session;
        }

        private static boolean isEmptyNode(PlanNode planNode) {
            return planNode instanceof ValuesNode && ((ValuesNode)planNode).getRows().size() == 0;
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenLeft = context.rewrite(node.getLeft());
            PlanNode rewrittenRight = context.rewrite(node.getRight());
            switch (node.getType()) {
                case INNER: {
                    if (!Rewriter.isEmptyNode(rewrittenLeft) && !Rewriter.isEmptyNode(rewrittenRight)) break;
                    return this.convertToEmptyValuesNode((PlanNode)node);
                }
                case LEFT: {
                    if (Rewriter.isEmptyNode(rewrittenLeft)) {
                        return this.convertToEmptyValuesNode((PlanNode)node);
                    }
                    if (!Rewriter.isEmptyNode(rewrittenRight)) break;
                    return this.convertJoinToProject(node, rewrittenLeft, rewrittenRight.getOutputVariables());
                }
                case RIGHT: {
                    if (Rewriter.isEmptyNode(rewrittenRight)) {
                        return this.convertToEmptyValuesNode((PlanNode)node);
                    }
                    if (!Rewriter.isEmptyNode(rewrittenLeft)) break;
                    return this.convertJoinToProject(node, rewrittenRight, rewrittenLeft.getOutputVariables());
                }
                case FULL: {
                    if (Rewriter.isEmptyNode(rewrittenLeft) && Rewriter.isEmptyNode(rewrittenRight)) {
                        return this.convertToEmptyValuesNode((PlanNode)node);
                    }
                    if (Rewriter.isEmptyNode(rewrittenLeft)) {
                        return this.convertJoinToProject(node, rewrittenRight, rewrittenLeft.getOutputVariables());
                    }
                    if (!Rewriter.isEmptyNode(rewrittenRight)) break;
                    return this.convertJoinToProject(node, rewrittenLeft, rewrittenRight.getOutputVariables());
                }
            }
            return node.replaceChildren((List)ImmutableList.of((Object)rewrittenLeft, (Object)rewrittenRight));
        }

        @Override
        public PlanNode visitSequence(SequenceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List<PlanNode> cteProducers = node.getCteProducers();
            ArrayList<PlanNode> newCteProducerList = new ArrayList<PlanNode>();
            HashSet<Integer> removedIndexes = new HashSet<Integer>();
            for (int i = cteProducers.size() - 1; i >= 0; --i) {
                PlanNode rewrittenProducer = context.rewrite(cteProducers.get(i));
                if (!Rewriter.isEmptyNode(rewrittenProducer)) {
                    newCteProducerList.add(rewrittenProducer);
                    continue;
                }
                this.planChanged = true;
                removedIndexes.add(i);
            }
            PlanNode rewrittenPrimarySource = context.rewrite(node.getPrimarySource());
            if (Rewriter.isEmptyNode(rewrittenPrimarySource) || newCteProducerList.isEmpty()) {
                return rewrittenPrimarySource;
            }
            if (!this.planChanged) {
                return node;
            }
            Collections.reverse(newCteProducerList);
            return new SequenceNode(node.getSourceLocation(), this.idAllocator.getNextId(), (List<PlanNode>)ImmutableList.copyOf(newCteProducerList), rewrittenPrimarySource, node.removeCteProducersFromCteDependencyGraph(removedIndexes));
        }

        public PlanNode visitCteProducer(CteProducerNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (Rewriter.isEmptyNode(rewrittenSource)) {
                this.session.getCteInformationCollector().disallowCteMaterialization(node.getCteId());
                return this.convertToEmptyValuesNode((PlanNode)node);
            }
            return node.replaceChildren((List)ImmutableList.of((Object)rewrittenSource));
        }

        public PlanNode visitCteConsumer(CteConsumerNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (!this.session.getCteInformationCollector().getCteInformationMap().get(node.getCteId()).isMaterialized()) {
                return this.convertToEmptyValuesNode((PlanNode)node);
            }
            return node;
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (Rewriter.isEmptyNode(rewrittenSource) && !node.hasDefaultOutput()) {
                return this.convertToEmptyValuesNode((PlanNode)node);
            }
            return node.replaceChildren((List)ImmutableList.of((Object)rewrittenSource));
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List rewrittenChildren = (List)node.getSources().stream().map(x -> context.rewrite((PlanNode)x)).collect(ImmutableList.toImmutableList());
            List nonEmptyChildIndex = (List)IntStream.range(0, rewrittenChildren.size()).filter(idx -> !Rewriter.isEmptyNode((PlanNode)rewrittenChildren.get(idx))).boxed().collect(ImmutableList.toImmutableList());
            if (nonEmptyChildIndex.isEmpty()) {
                return this.convertToEmptyValuesNode((PlanNode)node);
            }
            if (nonEmptyChildIndex.size() == 1) {
                this.planChanged = true;
                int index = (Integer)nonEmptyChildIndex.get(0);
                Assignments.Builder builder = Assignments.builder();
                builder.putAll((Map)node.getVariableMapping().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (VariableReferenceExpression)entry.getKey(), entry -> (RowExpression)((List)entry.getValue()).get(index))));
                return new ProjectNode(node.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)rewrittenChildren.get(index), builder.build(), ProjectNode.Locality.LOCAL);
            }
            if (nonEmptyChildIndex.size() < node.getSources().size()) {
                this.planChanged = true;
                List nonEmptyInput = (List)nonEmptyChildIndex.stream().map(x -> (PlanNode)node.getSources().get((int)x)).collect(ImmutableList.toImmutableList());
                Map newOutputToInputs = (Map)node.getVariableMapping().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (List)nonEmptyChildIndex.stream().map(idx -> (VariableReferenceExpression)((List)entry.getValue()).get((int)idx)).collect(ImmutableList.toImmutableList())));
                return new UnionNode(node.getSourceLocation(), this.idAllocator.getNextId(), nonEmptyInput, node.getOutputVariables(), newOutputToInputs);
            }
            return node.replaceChildren(rewrittenChildren);
        }

        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            PlanNode rewrittenFilterSource = context.rewrite(node.getFilteringSource());
            if (Rewriter.isEmptyNode(rewrittenSource)) {
                return this.convertToEmptyValuesNode((PlanNode)node);
            }
            if (Rewriter.isEmptyNode(rewrittenFilterSource)) {
                this.planChanged = true;
                Assignments.Builder builder = Assignments.builder();
                builder.putAll((Map)node.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> x.equals((Object)node.getSemiJoinOutput()) ? Expressions.constant(false, (Type)BooleanType.BOOLEAN) : x)));
                return new ProjectNode(node.getSourceLocation(), this.idAllocator.getNextId(), rewrittenSource, builder.build(), ProjectNode.Locality.LOCAL);
            }
            return node.replaceChildren((List)ImmutableList.of((Object)rewrittenSource, (Object)rewrittenFilterSource));
        }

        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty(node, context);
        }

        @Override
        public PlanNode visitOffset(OffsetNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty(node, context);
        }

        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty(node, context);
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty(node, context);
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.getCount() == 0L) {
                return this.convertToEmptyValuesNode((PlanNode)node);
            }
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty((PlanNode)node, context);
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty(node, context);
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.convertToEmptyNodeIfInputEmpty(node, context);
        }

        private PlanNode convertToEmptyValuesNode(PlanNode node) {
            this.planChanged = true;
            return new ValuesNode(node.getSourceLocation(), this.idAllocator.getNextId(), node.getOutputVariables(), (List)ImmutableList.of(), Optional.empty());
        }

        private ProjectNode convertJoinToProject(JoinNode joinNode, PlanNode nonEmptySource, List<VariableReferenceExpression> nullVariables) {
            this.planChanged = true;
            Assignments.Builder builder = Assignments.builder();
            builder.putAll((Map)joinNode.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(x -> x, x -> nullVariables.contains(x) ? Expressions.constantNull(x.getSourceLocation(), x.getType()) : x)));
            return new ProjectNode(joinNode.getSourceLocation(), this.idAllocator.getNextId(), nonEmptySource, builder.build(), ProjectNode.Locality.LOCAL);
        }

        private PlanNode convertToEmptyNodeIfInputEmpty(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List rewrittenChildren = (List)node.getSources().stream().map(x -> context.rewrite((PlanNode)x)).collect(ImmutableList.toImmutableList());
            if (rewrittenChildren.stream().allMatch(x -> Rewriter.isEmptyNode(x))) {
                return this.convertToEmptyValuesNode(node);
            }
            return node.replaceChildren(rewrittenChildren);
        }
    }
}

