/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.CteReferenceNode;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.DeleteNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IndexSourceNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SetOperationNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.SpatialJoinNode;
import com.facebook.presto.spi.plan.TableFinishNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeUtil;
import com.facebook.presto.sql.planner.optimizations.PartitioningUtils;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.UpdateNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UnaliasSymbolReferences
implements PlanOptimizer {
    private final FunctionAndTypeManager functionAndTypeManager;

    public UnaliasSymbolReferences(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(new Rewriter(types, this.functionAndTypeManager, warningCollector), plan);
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, !rewrittenPlan.equals(plan));
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Map<String, String> mapping = new HashMap<String, String>();
        private final TypeProvider types;
        private final RowExpressionDeterminismEvaluator determinismEvaluator;
        private final FunctionAndTypeManager functionAndTypeManager;
        private final WarningCollector warningCollector;

        private Rewriter(TypeProvider types, FunctionAndTypeManager functionAndTypeManager, WarningCollector warningCollector) {
            this.types = types;
            this.functionAndTypeManager = functionAndTypeManager;
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(functionAndTypeManager);
            this.warningCollector = warningCollector;
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types, this.warningCollector);
            return mapper.map(node, source);
        }

        public PlanNode visitCteReference(CteReferenceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new CteReferenceNode(node.getSourceLocation(), node.getId(), source, node.getCteId());
        }

        public PlanNode visitCteProducer(CteProducerNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List canonical = Lists.transform((List)node.getOutputVariables(), this::canonicalize);
            return new CteProducerNode(node.getSourceLocation(), node.getId(), source, node.getCteId(), node.getRowCountVariable(), canonical);
        }

        public PlanNode visitCteConsumer(CteConsumerNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return node;
        }

        @Override
        public PlanNode visitSequence(SequenceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List<PlanNode> cteProducers = node.getCteProducers().stream().map(c -> SimplePlanRewriter.rewriteWith(new Rewriter(this.types, this.functionAndTypeManager, this.warningCollector), c)).collect(Collectors.toList());
            PlanNode primarySource = context.rewrite(node.getPrimarySource());
            return new SequenceNode(node.getSourceLocation(), node.getId(), cteProducers, primarySource, node.getCteDependencyGraph());
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            HashMap<VariableReferenceExpression, VariableReferenceExpression> newGroupingMappings = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            ImmutableList.Builder newGroupingSets = ImmutableList.builder();
            for (List<VariableReferenceExpression> groupingSet : node.getGroupingSets()) {
                ImmutableList.Builder newGroupingSet = ImmutableList.builder();
                for (VariableReferenceExpression output : groupingSet) {
                    newGroupingMappings.putIfAbsent(this.canonicalize(output), this.canonicalize(node.getGroupingColumns().get(output)));
                    newGroupingSet.add((Object)this.canonicalize(output));
                }
                newGroupingSets.add((Object)newGroupingSet.build());
            }
            return new GroupIdNode(node.getSourceLocation(), node.getId(), source, (List<List<VariableReferenceExpression>>)newGroupingSets.build(), newGroupingMappings, this.canonicalizeAndDistinct(node.getAggregationArguments()), this.canonicalize(node.getGroupIdVariable()));
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ExplainAnalyzeNode(node.getSourceLocation(), node.getId(), source, this.canonicalize(node.getOutputVariable()), node.isVerbose(), node.getFormat());
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new MarkDistinctNode(node.getSourceLocation(), node.getId(), source, this.canonicalize(node.getMarkerVariable()), this.canonicalizeAndDistinct(node.getDistinctVariables()), this.canonicalize(node.getHashVariable()));
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : node.getUnnestVariables().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), entry.getValue());
            }
            return new UnnestNode(node.getSourceLocation(), node.getId(), source, this.canonicalizeAndDistinct(node.getReplicateVariables()), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)builder.build(), node.getOrdinalityVariable());
        }

        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder functions = ImmutableMap.builder();
            for (Map.Entry entry : node.getWindowFunctions().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                CallExpression callExpression = ((WindowNode.Function)entry.getValue()).getFunctionCall();
                List<RowExpression> rewrittenArguments = this.canonicalizeCallExpression(callExpression);
                WindowNode.Frame canonicalFrame = this.canonicalize(((WindowNode.Function)entry.getValue()).getFrame());
                functions.put((Object)this.canonicalize(variable), (Object)new WindowNode.Function(Expressions.call(callExpression.getDisplayName(), callExpression.getFunctionHandle(), callExpression.getType(), rewrittenArguments), canonicalFrame, ((WindowNode.Function)entry.getValue()).isIgnoreNulls()));
            }
            return new WindowNode(node.getSourceLocation(), node.getId(), source, this.canonicalizeAndDistinct(node.getSpecification()), (Map)functions.build(), this.canonicalize(node.getHashVariable()), this.canonicalize(node.getPrePartitionedInputs()), node.getPreSortedOrderPrefix());
        }

        private List<RowExpression> canonicalizeCallExpression(CallExpression callExpression) {
            return (List)callExpression.getArguments().stream().map(this::canonicalize).collect(ImmutableList.toImmutableList());
        }

        private WindowNode.Frame canonicalize(WindowNode.Frame frame) {
            return new WindowNode.Frame(frame.getType(), frame.getStartType(), this.canonicalize(frame.getStartValue()), this.canonicalize(frame.getSortKeyCoercedForFrameStartComparison()), frame.getEndType(), this.canonicalize(frame.getEndValue()), this.canonicalize(frame.getSortKeyCoercedForFrameEndComparison()), frame.getOriginalStartValue(), frame.getOriginalEndValue());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return node;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List sources = (List)node.getSources().stream().map(context::rewrite).collect(ImmutableList.toImmutableList());
            this.mapExchangeNodeSymbols(node);
            ArrayList<List<VariableReferenceExpression>> inputs = new ArrayList<List<VariableReferenceExpression>>();
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputs.add(new ArrayList());
            }
            HashSet<VariableReferenceExpression> addedOutputs = new HashSet<VariableReferenceExpression>();
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (int variableIndex = 0; variableIndex < node.getOutputVariables().size(); ++variableIndex) {
                VariableReferenceExpression canonicalOutput = this.canonicalize(node.getOutputVariables().get(variableIndex));
                if (!addedOutputs.add(canonicalOutput)) continue;
                outputs.add((Object)canonicalOutput);
                for (int i = 0; i < node.getInputs().size(); ++i) {
                    List<VariableReferenceExpression> input = node.getInputs().get(i);
                    ((List)inputs.get(i)).add(this.canonicalize(input.get(variableIndex)));
                }
            }
            PartitioningScheme partitioningScheme = new PartitioningScheme(PartitioningUtils.translateVariable(node.getPartitioningScheme().getPartitioning(), this::canonicalize), (List)outputs.build(), this.canonicalize(node.getPartitioningScheme().getHashColumn()), node.getPartitioningScheme().isReplicateNullsAndAny(), node.getPartitioningScheme().isScaleWriters(), node.getPartitioningScheme().getEncoding(), node.getPartitioningScheme().getBucketToPartition());
            Optional<OrderingScheme> orderingScheme = node.getOrderingScheme().map(this::canonicalizeAndDistinct);
            return new ExchangeNode(node.getSourceLocation(), node.getId(), node.getType(), node.getScope(), partitioningScheme, sources, inputs, node.isEnsureSourceOrdering(), orderingScheme);
        }

        private void mapExchangeNodeSymbols(ExchangeNode node) {
            if (node.getInputs().size() == 1) {
                this.mapExchangeNodeOutputToInputSymbols(node);
                return;
            }
            HashMap<List<VariableReferenceExpression>, VariableReferenceExpression> inputsToOutputs = new HashMap<List<VariableReferenceExpression>, VariableReferenceExpression>();
            for (int variableIndex = 0; variableIndex < node.getOutputVariables().size(); ++variableIndex) {
                VariableReferenceExpression canonicalOutput = this.canonicalize(node.getOutputVariables().get(variableIndex));
                List<VariableReferenceExpression> canonicalInputs = this.canonicalizeExchangeNodeInputs(node, variableIndex);
                VariableReferenceExpression output = (VariableReferenceExpression)inputsToOutputs.get(canonicalInputs);
                if (output == null || canonicalOutput.equals((Object)output)) {
                    inputsToOutputs.put(canonicalInputs, canonicalOutput);
                    continue;
                }
                this.map(canonicalOutput, output);
            }
        }

        private void mapExchangeNodeOutputToInputSymbols(ExchangeNode node) {
            Preconditions.checkState((node.getInputs().size() == 1 ? 1 : 0) != 0);
            for (int variableIndex = 0; variableIndex < node.getOutputVariables().size(); ++variableIndex) {
                VariableReferenceExpression canonicalInput;
                VariableReferenceExpression canonicalOutput = this.canonicalize(node.getOutputVariables().get(variableIndex));
                if (canonicalOutput.equals((Object)(canonicalInput = this.canonicalize(node.getInputs().get(0).get(variableIndex))))) continue;
                this.map(canonicalOutput, canonicalInput);
            }
        }

        private List<VariableReferenceExpression> canonicalizeExchangeNodeInputs(ExchangeNode node, int symbolIndex) {
            return (List)node.getInputs().stream().map(input -> this.canonicalize((VariableReferenceExpression)input.get(symbolIndex))).collect(ImmutableList.toImmutableList());
        }

        @Override
        public PlanNode visitRemoteSource(RemoteSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RemoteSourceNode(node.getSourceLocation(), node.getId(), node.getStatsEquivalentPlanNode(), node.getSourceFragmentIds(), this.canonicalizeAndDistinct(node.getOutputVariables()), node.isEnsureSourceOrdering(), node.getOrderingScheme().map(this::canonicalizeAndDistinct), node.getExchangeType(), node.getEncoding());
        }

        @Override
        public PlanNode visitOffset(OffsetNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite((PlanNode)node);
        }

        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DistinctLimitNode(node.getSourceLocation(), node.getId(), context.rewrite(node.getSource()), node.getLimit(), node.isPartial(), this.canonicalizeAndDistinct(node.getDistinctVariables()), this.canonicalize(node.getHashVariable()), node.getTimeoutMillis());
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new SampleNode(node.getSourceLocation(), node.getId(), context.rewrite(node.getSource()), node.getSampleRatio(), node.getSampleType());
        }

        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List canonicalizedRows = (List)node.getRows().stream().map(rowExpressions -> (ImmutableList)rowExpressions.stream().map(this::canonicalize).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            List<VariableReferenceExpression> canonicalizedOutputVariables = this.canonicalizeAndDistinct(node.getOutputVariables());
            Preconditions.checkState((node.getOutputVariables().size() == canonicalizedOutputVariables.size() ? 1 : 0) != 0, (Object)"Values output symbols were pruned");
            return new ValuesNode(node.getSourceLocation(), node.getId(), canonicalizedOutputVariables, canonicalizedRows, node.getValuesNodeLabel());
        }

        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DeleteNode(node.getSourceLocation(), node.getId(), context.rewrite(node.getSource()), this.canonicalize(node.getRowId()), node.getOutputVariables(), node.getInputDistribution());
        }

        @Override
        public PlanNode visitUpdate(UpdateNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new UpdateNode(node.getSourceLocation(), node.getId(), node.getSource(), this.canonicalize(node.getRowId()), node.getColumnValueAndRowIdSymbols(), node.getOutputVariables());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types, this.warningCollector);
            return mapper.map(node, source);
        }

        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types, this.warningCollector);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RowNumberNode(node.getSourceLocation(), node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getPartitionBy()), this.canonicalize(node.getRowNumberVariable()), node.getMaxRowCountPerPartition(), node.isPartial(), this.canonicalize(node.getHashVariable()));
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new TopNRowNumberNode(node.getSourceLocation(), node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getSpecification()), this.canonicalize(node.getRowNumberVariable()), node.getMaxRowCountPerPartition(), node.isPartial(), this.canonicalize(node.getHashVariable()));
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new FilterNode(node.getSourceLocation(), node.getId(), source, this.canonicalize(node.getPredicate()));
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ProjectNode(node.getSourceLocation(), node.getId(), source, this.canonicalize(node.getAssignments()), node.getLocality());
        }

        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List canonical = Lists.transform((List)node.getOutputVariables(), this::canonicalize);
            return new OutputNode(node.getSourceLocation(), node.getId(), source, node.getColumnNames(), canonical);
        }

        @Override
        public PlanNode visitEnforceSingleRow(EnforceSingleRowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new EnforceSingleRowNode((Optional<SourceLocation>)node.getSourceLocation(), node.getId(), source);
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new AssignUniqueId(node.getSourceLocation(), node.getId(), source, node.getIdVariable());
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            List canonicalCorrelation = Lists.transform(node.getCorrelation(), this::canonicalize);
            Assignments assignments = this.canonicalize(node.getSubqueryAssignments());
            ApplyNodeUtil.verifySubquerySupported(assignments);
            return new ApplyNode(node.getSourceLocation(), node.getId(), source, subquery, assignments, canonicalCorrelation, node.getOriginSubqueryError(), node.getMayParticipateInAntiJoin());
        }

        @Override
        public PlanNode visitLateralJoin(LateralJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            List<VariableReferenceExpression> canonicalCorrelation = this.canonicalizeAndDistinct(node.getCorrelation());
            return new LateralJoinNode(node.getSourceLocation(), node.getId(), source, subquery, canonicalCorrelation, node.getType(), node.getOriginSubqueryError());
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types, this.warningCollector);
            return mapper.map(node, source, node.getId());
        }

        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new SortNode(node.getSourceLocation(), node.getId(), source, this.canonicalizeAndDistinct(node.getOrderingScheme()), node.isPartial(), node.getPartitionBy());
        }

        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            List<EquiJoinClause> canonicalCriteria = this.canonicalizeJoinCriteria(node.getCriteria());
            Optional<RowExpression> canonicalFilter = node.getFilter().map(this::canonicalize);
            Optional<VariableReferenceExpression> canonicalLeftHashVariable = this.canonicalize(node.getLeftHashVariable());
            Optional<VariableReferenceExpression> canonicalRightHashVariable = this.canonicalize(node.getRightHashVariable());
            Map<String, VariableReferenceExpression> canonicalDynamicFilters = this.canonicalizeAndDistinct(node.getDynamicFilters());
            if (node.getType().equals((Object)JoinType.INNER)) {
                canonicalCriteria.stream().filter(clause -> clause.getLeft().getType().equals(clause.getRight().getType()) && clause.getLeft().getType().equalValuesAreIdentical()).filter(clause -> node.getOutputVariables().contains(clause.getLeft())).forEach(clause -> this.map(clause.getRight(), clause.getLeft()));
            }
            return new JoinNode(node.getSourceLocation(), node.getId(), node.getType(), left, right, canonicalCriteria, this.canonicalizeAndDistinct(node.getOutputVariables()), canonicalFilter, canonicalLeftHashVariable, canonicalRightHashVariable, node.getDistributionType(), canonicalDynamicFilters);
        }

        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            PlanNode filteringSource = context.rewrite(node.getFilteringSource());
            return new SemiJoinNode(node.getSourceLocation(), node.getId(), source, filteringSource, this.canonicalize(node.getSourceJoinVariable()), this.canonicalize(node.getFilteringSourceJoinVariable()), this.canonicalize(node.getSemiJoinOutput()), this.canonicalize(node.getSourceHashVariable()), this.canonicalize(node.getFilteringSourceHashVariable()), node.getDistributionType(), node.getDynamicFilters());
        }

        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            return new SpatialJoinNode(node.getSourceLocation(), node.getId(), node.getType(), left, right, this.canonicalizeAndDistinct(node.getOutputVariables()), this.canonicalize(node.getFilter()), this.canonicalize(node.getLeftPartitionVariable()), this.canonicalize(node.getRightPartitionVariable()), node.getKdbTree());
        }

        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IndexSourceNode(node.getSourceLocation(), node.getId(), node.getIndexHandle(), node.getTableHandle(), this.canonicalize(node.getLookupVariables()), node.getOutputVariables(), node.getAssignments(), node.getCurrentConstraint());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode probeSource = context.rewrite(node.getProbeSource());
            PlanNode indexSource = context.rewrite(node.getIndexSource());
            return new IndexJoinNode(node.getSourceLocation(), node.getId(), node.getType(), probeSource, indexSource, this.canonicalizeIndexJoinCriteria(node.getCriteria()), node.getFilter().map(this::canonicalize), this.canonicalize(node.getProbeHashVariable()), this.canonicalize(node.getIndexHashVariable()));
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new UnionNode(node.getSourceLocation(), node.getId(), (List)Rewriter.rewriteSources((SetOperationNode)node, context).build(), this.canonicalizeSetOperationOutputVariables(node.getOutputVariables()), this.canonicalizeSetOperationVariableMap(node.getVariableMapping()));
        }

        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IntersectNode(node.getSourceLocation(), node.getId(), (List)Rewriter.rewriteSources((SetOperationNode)node, context).build(), this.canonicalizeSetOperationOutputVariables(node.getOutputVariables()), this.canonicalizeSetOperationVariableMap(node.getVariableMapping()));
        }

        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new ExceptNode(node.getSourceLocation(), node.getId(), (List)Rewriter.rewriteSources((SetOperationNode)node, context).build(), this.canonicalizeSetOperationOutputVariables(node.getOutputVariables()), this.canonicalizeSetOperationVariableMap(node.getVariableMapping()));
        }

        private static ImmutableList.Builder<PlanNode> rewriteSources(SetOperationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                rewrittenSources.add((Object)context.rewrite(source));
            }
            return rewrittenSources;
        }

        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types, this.warningCollector);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitTableWriteMerge(TableWriterMergeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types, this.warningCollector);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        private void map(VariableReferenceExpression variable, VariableReferenceExpression canonical) {
            Preconditions.checkArgument((!variable.equals((Object)canonical) ? 1 : 0) != 0, (String)"Can't map variable to itself: %s", (Object)variable);
            this.mapping.put(variable.getName(), canonical.getName());
        }

        private Assignments canonicalize(Assignments oldAssignments) {
            HashMap<RowExpression, VariableReferenceExpression> computedExpressions = new HashMap<RowExpression, VariableReferenceExpression>();
            Assignments.Builder assignments = Assignments.builder();
            for (Map.Entry entry : oldAssignments.getMap().entrySet()) {
                RowExpression expression = this.canonicalize((RowExpression)entry.getValue());
                if (expression instanceof VariableReferenceExpression) {
                    VariableReferenceExpression variable = (VariableReferenceExpression)expression;
                    if (!variable.getName().equals(((VariableReferenceExpression)entry.getKey()).getName())) {
                        this.map((VariableReferenceExpression)entry.getKey(), variable);
                    }
                } else if (!Expressions.isNull(expression) && this.determinismEvaluator.isDeterministic(expression)) {
                    VariableReferenceExpression computedVariable = (VariableReferenceExpression)computedExpressions.get(expression);
                    if (computedVariable == null) {
                        computedExpressions.put(expression, (VariableReferenceExpression)entry.getKey());
                    } else {
                        this.map((VariableReferenceExpression)entry.getKey(), computedVariable);
                    }
                }
                VariableReferenceExpression canonical = this.canonicalize((VariableReferenceExpression)entry.getKey());
                assignments.put(canonical, expression);
            }
            return assignments.build();
        }

        private VariableReferenceExpression canonicalize(VariableReferenceExpression variable) {
            String canonical = variable.getName();
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return new VariableReferenceExpression(variable.getSourceLocation(), canonical, this.types.get((Expression)new SymbolReference(ExpressionTreeUtils.getNodeLocation(variable.getSourceLocation()), canonical)));
        }

        private Optional<VariableReferenceExpression> canonicalize(Optional<VariableReferenceExpression> variable) {
            if (variable.isPresent()) {
                return Optional.of(this.canonicalize(variable.get()));
            }
            return Optional.empty();
        }

        private RowExpression canonicalize(RowExpression value) {
            return RowExpressionVariableInliner.inlineVariables(this::canonicalize, value);
        }

        private List<VariableReferenceExpression> canonicalizeAndDistinct(List<VariableReferenceExpression> outputs) {
            HashSet<VariableReferenceExpression> added = new HashSet<VariableReferenceExpression>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (VariableReferenceExpression variable : outputs) {
                VariableReferenceExpression canonical = this.canonicalize(variable);
                if (!added.add(canonical)) continue;
                builder.add((Object)canonical);
            }
            return builder.build();
        }

        private Map<String, VariableReferenceExpression> canonicalizeAndDistinct(Map<String, VariableReferenceExpression> dynamicFilters) {
            HashSet<VariableReferenceExpression> added = new HashSet<VariableReferenceExpression>();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, VariableReferenceExpression> entry : dynamicFilters.entrySet()) {
                VariableReferenceExpression canonical = this.canonicalize(entry.getValue());
                if (!added.add(canonical)) continue;
                builder.put((Object)entry.getKey(), (Object)canonical);
            }
            return builder.build();
        }

        private DataOrganizationSpecification canonicalizeAndDistinct(DataOrganizationSpecification specification) {
            return new DataOrganizationSpecification(this.canonicalizeAndDistinct(specification.getPartitionBy()), specification.getOrderingScheme().map(this::canonicalizeAndDistinct));
        }

        private OrderingScheme canonicalizeAndDistinct(OrderingScheme orderingScheme) {
            HashSet<VariableReferenceExpression> added = new HashSet<VariableReferenceExpression>();
            ImmutableList.Builder variables = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (VariableReferenceExpression variable2 : orderingScheme.getOrderByVariables()) {
                VariableReferenceExpression canonical = this.canonicalize(variable2);
                if (!added.add(canonical)) continue;
                variables.add((Object)canonical);
                orderings.put((Object)canonical, (Object)orderingScheme.getOrdering(variable2));
            }
            ImmutableMap orderingsMap = orderings.build();
            return new OrderingScheme((List)variables.build().stream().map(variable -> new Ordering(variable, (SortOrder)orderingsMap.get(variable))).collect(ImmutableList.toImmutableList()));
        }

        private Set<VariableReferenceExpression> canonicalize(Set<VariableReferenceExpression> variables) {
            return (Set)variables.stream().map(this::canonicalize).collect(ImmutableSet.toImmutableSet());
        }

        private List<EquiJoinClause> canonicalizeJoinCriteria(List<EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (EquiJoinClause clause : criteria) {
                builder.add((Object)new EquiJoinClause(this.canonicalize(clause.getLeft()), this.canonicalize(clause.getRight())));
            }
            return builder.build();
        }

        private List<IndexJoinNode.EquiJoinClause> canonicalizeIndexJoinCriteria(List<IndexJoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(this.canonicalize(clause.getProbe()), this.canonicalize(clause.getIndex())));
            }
            return builder.build();
        }

        private Map<VariableReferenceExpression, List<VariableReferenceExpression>> canonicalizeSetOperationVariableMap(Map<VariableReferenceExpression, List<VariableReferenceExpression>> setOperationVariableMap) {
            LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>> result = new LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>>();
            HashSet<VariableReferenceExpression> addVariables = new HashSet<VariableReferenceExpression>();
            for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : setOperationVariableMap.entrySet()) {
                VariableReferenceExpression canonicalOutputVariable = this.canonicalize(entry.getKey());
                if (!addVariables.add(canonicalOutputVariable)) continue;
                result.put(canonicalOutputVariable, (List<VariableReferenceExpression>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)entry.getValue(), this::canonicalize)));
            }
            return result;
        }

        private List<VariableReferenceExpression> canonicalizeSetOperationOutputVariables(List<VariableReferenceExpression> setOperationOutputVariables) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (VariableReferenceExpression variable : setOperationOutputVariables) {
                builder.add((Object)this.canonicalize(variable));
            }
            return builder.build();
        }
    }
}

