/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public class AssignmentUtils {
    private AssignmentUtils() {
    }

    public static Assignments identityAssignments(Collection<VariableReferenceExpression> variables) {
        Assignments.Builder builder = Assignments.builder();
        variables.forEach(variable -> builder.put(variable, (RowExpression)variable));
        return builder.build();
    }

    public static Assignments identityAssignments(VariableReferenceExpression ... variables) {
        return AssignmentUtils.identityAssignments(Arrays.asList(variables));
    }

    public static boolean isIdentity(Assignments assignments) {
        for (Map.Entry assignment : assignments.entrySet()) {
            if (((VariableReferenceExpression)assignment.getKey()).equals(assignment.getValue())) continue;
            return false;
        }
        return true;
    }

    public static Map<VariableReferenceExpression, RowExpression> getNonIdentityAssignments(Assignments assignments) {
        ImmutableMap.Builder nonIdentityAssignments = ImmutableMap.builder();
        for (Map.Entry assignment : assignments.entrySet()) {
            if (((VariableReferenceExpression)assignment.getKey()).equals(assignment.getValue())) continue;
            nonIdentityAssignments.put(assignment);
        }
        return nonIdentityAssignments.build();
    }

    public static boolean isIdentity(Assignments assignments, VariableReferenceExpression output) {
        RowExpression value = assignments.get(output);
        return value instanceof VariableReferenceExpression && ((VariableReferenceExpression)value).getName().equals(output.getName());
    }

    public static Assignments rewrite(Assignments assignments, Function<RowExpression, RowExpression> rewrite) {
        return assignments.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((VariableReferenceExpression)entry.getKey()), (Object)((RowExpression)rewrite.apply((RowExpression)entry.getValue())))).collect(AssignmentUtils.toAssignments());
    }

    private static Collector<Map.Entry<VariableReferenceExpression, RowExpression>, Assignments.Builder, Assignments> toAssignments() {
        return Collector.of(Assignments::builder, (builder, entry) -> builder.put((VariableReferenceExpression)entry.getKey(), (RowExpression)entry.getValue()), (left, right) -> {
            left.putAll(right.build());
            return left;
        }, Assignments.Builder::build, new Collector.Characteristics[0]);
    }
}

