/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExplainAnalyzeNode
extends InternalPlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression outputVariable;
    private final boolean verbose;
    private final ExplainFormat.Type format;

    @JsonCreator
    public ExplainAnalyzeNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="outputVariable") VariableReferenceExpression outputVariable, @JsonProperty(value="verbose") boolean verbose, @JsonProperty(value="format") ExplainFormat.Type format) {
        this(sourceLocation, id, Optional.empty(), source, outputVariable, verbose, format);
    }

    public ExplainAnalyzeNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, VariableReferenceExpression outputVariable, boolean verbose, ExplainFormat.Type format) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source, "source is null");
        this.outputVariable = Objects.requireNonNull(outputVariable, "outputVariable is null");
        this.verbose = verbose;
        this.format = Objects.requireNonNull(format, "options is null");
    }

    @JsonProperty(value="outputVariable")
    public VariableReferenceExpression getOutputVariable() {
        return this.outputVariable;
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="verbose")
    public boolean isVerbose() {
        return this.verbose;
    }

    @JsonProperty(value="format")
    public ExplainFormat.Type getFormat() {
        return this.format;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.of((Object)this.outputVariable);
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitExplainAnalyze(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ExplainAnalyzeNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), (PlanNode)Iterables.getOnlyElement(newChildren), this.outputVariable, this.isVerbose(), this.format);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new ExplainAnalyzeNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.outputVariable, this.isVerbose(), this.format);
    }
}

