/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexJoinNode
extends InternalPlanNode {
    private final JoinType type;
    private final PlanNode probeSource;
    private final PlanNode indexSource;
    private final List<EquiJoinClause> criteria;
    private final Optional<RowExpression> filter;
    private final Optional<VariableReferenceExpression> probeHashVariable;
    private final Optional<VariableReferenceExpression> indexHashVariable;

    @JsonCreator
    public IndexJoinNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") JoinType type, @JsonProperty(value="probeSource") PlanNode probeSource, @JsonProperty(value="indexSource") PlanNode indexSource, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="filter") Optional<RowExpression> filter, @JsonProperty(value="probeHashVariable") Optional<VariableReferenceExpression> probeHashVariable, @JsonProperty(value="indexHashVariable") Optional<VariableReferenceExpression> indexHashVariable) {
        this(sourceLocation, id, Optional.empty(), type, probeSource, indexSource, criteria, filter, probeHashVariable, indexHashVariable);
    }

    public IndexJoinNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, JoinType type, PlanNode probeSource, PlanNode indexSource, List<EquiJoinClause> criteria, Optional<RowExpression> filter, Optional<VariableReferenceExpression> probeHashVariable, Optional<VariableReferenceExpression> indexHashVariable) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.type = Objects.requireNonNull(type, "type is null");
        this.probeSource = Objects.requireNonNull(probeSource, "probeSource is null");
        this.indexSource = Objects.requireNonNull(indexSource, "indexSource is null");
        this.criteria = ImmutableList.copyOf((Collection)Objects.requireNonNull(criteria, "criteria is null"));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.probeHashVariable = Objects.requireNonNull(probeHashVariable, "probeHashVariable is null");
        this.indexHashVariable = Objects.requireNonNull(indexHashVariable, "indexHashVariable is null");
    }

    @JsonProperty
    public JoinType getType() {
        return this.type;
    }

    @JsonProperty
    public PlanNode getProbeSource() {
        return this.probeSource;
    }

    @JsonProperty
    public PlanNode getIndexSource() {
        return this.indexSource;
    }

    @JsonProperty
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty
    public Optional<RowExpression> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getProbeHashVariable() {
        return this.probeHashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getIndexHashVariable() {
        return this.indexHashVariable;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.probeSource, (Object)this.indexSource);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.probeSource.getOutputVariables()).addAll((Iterable)this.indexSource.getOutputVariables()).build();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitIndexJoin(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new IndexJoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.filter, this.probeHashVariable, this.indexHashVariable);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new IndexJoinNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.type, this.probeSource, this.indexSource, this.criteria, this.filter, this.probeHashVariable, this.indexHashVariable);
    }

    public static class EquiJoinClause {
        private final VariableReferenceExpression probe;
        private final VariableReferenceExpression index;

        @JsonCreator
        public EquiJoinClause(@JsonProperty(value="left") VariableReferenceExpression probe, @JsonProperty(value="right") VariableReferenceExpression index) {
            this.probe = Objects.requireNonNull(probe, "probe is null");
            this.index = Objects.requireNonNull(index, "index is null");
        }

        @JsonProperty(value="left")
        public VariableReferenceExpression getProbe() {
            return this.probe;
        }

        @JsonProperty(value="right")
        public VariableReferenceExpression getIndex() {
            return this.index;
        }
    }
}

