/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanCheckerProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.SimplePlanFragment;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.sanity.CheckUnsupportedExternalFunctions;
import com.facebook.presto.sql.planner.sanity.CheckUnsupportedPrestissimoTypes;
import com.facebook.presto.sql.planner.sanity.DynamicFiltersChecker;
import com.facebook.presto.sql.planner.sanity.NoDuplicatePlanNodeIdsChecker;
import com.facebook.presto.sql.planner.sanity.PlanCheckerProviderManager;
import com.facebook.presto.sql.planner.sanity.TypeValidator;
import com.facebook.presto.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import com.facebook.presto.sql.planner.sanity.ValidateDependenciesChecker;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingAggregations;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingJoins;
import com.facebook.presto.sql.planner.sanity.VerifyNoFilteredAggregations;
import com.facebook.presto.sql.planner.sanity.VerifyNoIntermediateFormExpression;
import com.facebook.presto.sql.planner.sanity.VerifyNoUnresolvedSymbolExpression;
import com.facebook.presto.sql.planner.sanity.VerifyOnlyOneOutputNode;
import com.facebook.presto.sql.planner.sanity.VerifyProjectionLocality;
import com.facebook.presto.sql.planner.sanity.WarnOnScanWithoutPartitionPredicate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import javax.inject.Inject;

public final class PlanChecker {
    private final Multimap<Stage, Checker> checkers;
    private final PlanCheckerProviderManager planCheckerProviderManager;

    @Inject
    public PlanChecker(FeaturesConfig featuresConfig, PlanCheckerProviderManager planCheckerProviderManager) {
        this(featuresConfig, false, planCheckerProviderManager);
    }

    public PlanChecker(FeaturesConfig featuresConfig, boolean noExchange, PlanCheckerProviderManager planCheckerProviderManager) {
        this.planCheckerProviderManager = Objects.requireNonNull(planCheckerProviderManager, "planCheckerProviderManager is null");
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Object)Stage.INTERMEDIATE, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new VerifyOnlyOneOutputNode(), new VerifyNoUnresolvedSymbolExpression()}).putAll((Object)Stage.FRAGMENT, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new VerifyNoFilteredAggregations(), new VerifyNoIntermediateFormExpression(), new ValidateStreamingJoins(featuresConfig)}).putAll((Object)Stage.FINAL, (Object[])new Checker[]{new CheckUnsupportedExternalFunctions(), new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations(), new ValidateAggregationsWithDefaultValues(noExchange, featuresConfig.isNativeExecutionEnabled()), new ValidateStreamingAggregations(featuresConfig.isNativeExecutionEnabled()), new VerifyNoIntermediateFormExpression(), new VerifyProjectionLocality(), new DynamicFiltersChecker(), new WarnOnScanWithoutPartitionPredicate(featuresConfig)});
        if (featuresConfig.isNativeExecutionEnabled() && (featuresConfig.isDisableTimeStampWithTimeZoneForNative() || featuresConfig.isDisableIPAddressForNative())) {
            builder.put((Object)Stage.INTERMEDIATE, (Object)new CheckUnsupportedPrestissimoTypes(featuresConfig));
        }
        this.checkers = builder.build();
    }

    public void validateFinalPlan(PlanNode planNode, Session session, Metadata metadata, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.FINAL).forEach(checker -> checker.validate(planNode, session, metadata, warningCollector));
        for (PlanCheckerProvider provider : this.planCheckerProviderManager.getPlanCheckerProviders()) {
            for (com.facebook.presto.spi.plan.PlanChecker checker2 : provider.getFinalPlanCheckers()) {
                checker2.validate(planNode, warningCollector, session.toConnectorSession());
            }
        }
    }

    public void validateIntermediatePlan(PlanNode planNode, Session session, Metadata metadata, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.INTERMEDIATE).forEach(checker -> checker.validate(planNode, session, metadata, warningCollector));
        for (PlanCheckerProvider provider : this.planCheckerProviderManager.getPlanCheckerProviders()) {
            for (com.facebook.presto.spi.plan.PlanChecker checker2 : provider.getIntermediatePlanCheckers()) {
                checker2.validate(planNode, warningCollector, session.toConnectorSession());
            }
        }
    }

    public void validatePlanFragment(PlanFragment planFragment, Session session, Metadata metadata, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.FRAGMENT).forEach(checker -> checker.validateFragment(planFragment, session, metadata, warningCollector));
        for (PlanCheckerProvider provider : this.planCheckerProviderManager.getPlanCheckerProviders()) {
            for (com.facebook.presto.spi.plan.PlanChecker checker2 : provider.getFragmentPlanCheckers()) {
                checker2.validateFragment(new SimplePlanFragment(planFragment.getId(), planFragment.getRoot(), planFragment.getVariables(), planFragment.getPartitioning(), planFragment.getTableScanSchedulingOrder(), planFragment.getPartitioningScheme(), planFragment.getStageExecutionDescriptor(), planFragment.isOutputTableWriterFragment()), warningCollector, session.toConnectorSession());
            }
        }
    }

    private static enum Stage {
        INTERMEDIATE,
        FINAL,
        FRAGMENT;

    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, Metadata var3, WarningCollector var4);

        default public void validateFragment(PlanFragment planFragment, Session session, Metadata metadata, WarningCollector warningCollector) {
            this.validate(planFragment.getRoot(), session, metadata, warningCollector);
        }
    }
}

