/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.StreamPreferredProperties;
import com.facebook.presto.sql.planner.optimizations.StreamPropertyDerivations;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ValidateStreamingJoins
implements PlanChecker.Checker {
    private final boolean nativeExecutionEnabled;

    public ValidateStreamingJoins(FeaturesConfig featuresConfig) {
        this.nativeExecutionEnabled = Objects.requireNonNull(featuresConfig).isNativeExecutionEnabled();
    }

    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, WarningCollector warningCollector) {
        planNode.accept((PlanVisitor)new Visitor(session, metadata, this.nativeExecutionEnabled), null);
    }

    private static final class Visitor
    extends InternalPlanVisitor<Void, Void> {
        private final Session session;
        private final Metadata metadata;
        private final boolean nativeExecutionEnabled;

        private Visitor(Session session, Metadata metadata, boolean nativeExecutionEnabled) {
            this.session = session;
            this.metadata = metadata;
            this.nativeExecutionEnabled = nativeExecutionEnabled;
        }

        public Void visitPlan(PlanNode node, Void context) {
            node.getSources().forEach(source -> source.accept((PlanVisitor)this, (Object)context));
            return null;
        }

        public Void visitJoin(JoinNode node, Void context) {
            if (!PlanNodeSearcher.searchFrom((PlanNode)node).where(RemoteSourceNode.class::isInstance).matches()) {
                List buildJoinVariables = (List)node.getCriteria().stream().map(EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
                StreamPreferredProperties requiredBuildProperty = SystemSessionProperties.getTaskConcurrency(this.session) > 1 ? (this.nativeExecutionEnabled && !SystemSessionProperties.isNativeJoinBuildPartitionEnforced(this.session) ? StreamPreferredProperties.defaultParallelism(this.session) : StreamPreferredProperties.exactlyPartitionedOn(buildJoinVariables)) : StreamPreferredProperties.singleStream();
                StreamPropertyDerivations.StreamProperties buildProperties = StreamPropertyDerivations.derivePropertiesRecursively(node.getRight(), this.metadata, this.session, this.nativeExecutionEnabled);
                Preconditions.checkArgument((boolean)requiredBuildProperty.isSatisfiedBy(buildProperties), (String)"Build side needs an additional local exchange for join: %s", (Object)node.getId());
                StreamPreferredProperties requiredProbeProperty = SystemSessionProperties.isSpillEnabled(this.session) && SystemSessionProperties.isJoinSpillingEnabled(this.session) && !this.nativeExecutionEnabled ? StreamPreferredProperties.fixedParallelism() : StreamPreferredProperties.defaultParallelism(this.session);
                StreamPropertyDerivations.StreamProperties probeProperties = StreamPropertyDerivations.derivePropertiesRecursively(node.getLeft(), this.metadata, this.session, this.nativeExecutionEnabled);
                Preconditions.checkArgument((boolean)requiredProbeProperty.isSatisfiedBy(probeProperties), (String)"Probe side needs an additional local exchange for join: %s", (Object)node.getId());
            }
            return null;
        }
    }
}

