/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.ExpressionOptimizerProvider;
import com.facebook.presto.spi.relation.PredicateCompiler;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.sql.planner.planPrinter.RowExpressionFormatter;
import java.util.Objects;

public final class ConnectorRowExpressionService
implements RowExpressionService {
    private final DomainTranslator domainTranslator;
    private final ExpressionOptimizerProvider expressionOptimizerProvider;
    private final PredicateCompiler predicateCompiler;
    private final DeterminismEvaluator determinismEvaluator;
    private final RowExpressionFormatter rowExpressionFormatter;

    public ConnectorRowExpressionService(DomainTranslator domainTranslator, ExpressionOptimizerProvider expressionOptimizerProvider, PredicateCompiler predicateCompiler, DeterminismEvaluator determinismEvaluator, RowExpressionFormatter rowExpressionFormatter) {
        this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
        this.expressionOptimizerProvider = Objects.requireNonNull(expressionOptimizerProvider, "expressionOptimizerProvider is null");
        this.predicateCompiler = Objects.requireNonNull(predicateCompiler, "predicateCompiler is null");
        this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
        this.rowExpressionFormatter = Objects.requireNonNull(rowExpressionFormatter, "rowExpressionFormatter is null");
    }

    public DomainTranslator getDomainTranslator() {
        return this.domainTranslator;
    }

    public ExpressionOptimizer getExpressionOptimizer(ConnectorSession session) {
        return this.expressionOptimizerProvider.getExpressionOptimizer(session);
    }

    public PredicateCompiler getPredicateCompiler() {
        return this.predicateCompiler;
    }

    public DeterminismEvaluator getDeterminismEvaluator() {
        return this.determinismEvaluator;
    }

    public String formatRowExpression(ConnectorSession session, RowExpression expression) {
        return this.rowExpressionFormatter.formatRowExpression(session, expression);
    }
}

