/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.LikePatternType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class FunctionResolution
implements StandardFunctionResolution {
    private final FunctionAndTypeResolver functionAndTypeResolver;
    private final List<QualifiedObjectName> windowValueFunctions;

    public FunctionResolution(FunctionAndTypeResolver functionAndTypeResolver) {
        this.functionAndTypeResolver = Objects.requireNonNull(functionAndTypeResolver, "functionManager is null");
        this.windowValueFunctions = ImmutableList.of((Object)functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"lead")), (Object)functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"lag")), (Object)functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"first_value")), (Object)functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"last_value")), (Object)functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"nth_value")));
    }

    public FunctionHandle notFunction() {
        return this.functionAndTypeResolver.lookupFunction("not", TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN}));
    }

    public boolean isNotFunction(FunctionHandle functionHandle) {
        return this.notFunction().equals(functionHandle);
    }

    public FunctionHandle likeVarcharFunction() {
        return this.functionAndTypeResolver.lookupFunction("LIKE", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN}));
    }

    public boolean supportsLikePatternFunction() {
        try {
            this.functionAndTypeResolver.lookupFunction("LIKE_PATTERN", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
            return true;
        }
        catch (PrestoException e) {
            if (e.getErrorCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode()) {
                return false;
            }
            throw e;
        }
    }

    public FunctionHandle likeVarcharVarcharFunction() {
        return this.functionAndTypeResolver.lookupFunction("LIKE", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    }

    public FunctionHandle likeVarcharVarcharVarcharFunction() {
        return this.functionAndTypeResolver.lookupFunction("LIKE", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}));
    }

    public FunctionHandle likeCharFunction(Type valueType) {
        Preconditions.checkArgument((boolean)(valueType instanceof CharType), (Object)"Expected CHAR value type");
        return this.functionAndTypeResolver.lookupFunction("LIKE", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType, LikePatternType.LIKE_PATTERN}));
    }

    public boolean isLikeFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"LIKE"));
    }

    public FunctionHandle likePatternFunction() {
        return this.functionAndTypeResolver.lookupFunction("LIKE_PATTERN", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    }

    public boolean isLikePatternFunction(FunctionHandle functionHandle) {
        QualifiedObjectName name = this.supportsLikePatternFunction() ? this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"LIKE_PATTERN")) : QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"LIKE_PATTERN");
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)name);
    }

    public boolean isCastFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.CAST));
    }

    public boolean isTryCastFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"TRY_CAST"));
    }

    public boolean isArrayConstructor(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"array_constructor")));
    }

    public FunctionHandle betweenFunction(Type valueType, Type lowerBoundType, Type upperBoundType) {
        return this.functionAndTypeResolver.lookupFunction(OperatorType.BETWEEN.getFunctionName().getObjectName(), TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType, lowerBoundType, upperBoundType}));
    }

    public boolean isBetweenFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.BETWEEN));
    }

    public FunctionHandle arithmeticFunction(OperatorType operator, Type leftType, Type rightType) {
        Preconditions.checkArgument((boolean)operator.isArithmeticOperator(), (Object)String.format("unexpected arithmetic type %s", operator));
        return this.functionAndTypeResolver.resolveOperator(operator, TypeSignatureProvider.fromTypes((Type[])new Type[]{leftType, rightType}));
    }

    public FunctionHandle arithmeticFunction(ArithmeticBinaryExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case ADD: {
                operatorType = OperatorType.ADD;
                break;
            }
            case SUBTRACT: {
                operatorType = OperatorType.SUBTRACT;
                break;
            }
            case MULTIPLY: {
                operatorType = OperatorType.MULTIPLY;
                break;
            }
            case DIVIDE: {
                operatorType = OperatorType.DIVIDE;
                break;
            }
            case MODULUS: {
                operatorType = OperatorType.MODULUS;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown arithmetic operator: " + operator);
            }
        }
        return this.arithmeticFunction(operatorType, leftType, rightType);
    }

    public boolean isArithmeticFunction(FunctionHandle functionHandle) {
        Optional operatorType = this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType();
        return operatorType.isPresent() && ((OperatorType)operatorType.get()).isArithmeticOperator();
    }

    public FunctionHandle negateFunction(Type type) {
        return this.functionAndTypeResolver.lookupFunction(OperatorType.NEGATION.getFunctionName().getObjectName(), TypeSignatureProvider.fromTypes((Type[])new Type[]{type}));
    }

    public boolean isNegateFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.NEGATION));
    }

    public FunctionHandle arrayConstructor(List<? extends Type> argumentTypes) {
        return this.functionAndTypeResolver.lookupFunction("array_constructor", TypeSignatureProvider.fromTypes(argumentTypes));
    }

    public FunctionHandle comparisonFunction(OperatorType operator, Type leftType, Type rightType) {
        Preconditions.checkArgument((boolean)operator.isComparisonOperator(), (Object)String.format("unexpected comparison type %s", operator));
        return this.functionAndTypeResolver.resolveOperator(operator, TypeSignatureProvider.fromTypes((Type[])new Type[]{leftType, rightType}));
    }

    public FunctionHandle comparisonFunction(ComparisonExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case EQUAL: {
                operatorType = OperatorType.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                operatorType = OperatorType.NOT_EQUAL;
                break;
            }
            case LESS_THAN: {
                operatorType = OperatorType.LESS_THAN;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                break;
            }
            case GREATER_THAN: {
                operatorType = OperatorType.GREATER_THAN;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                operatorType = OperatorType.GREATER_THAN_OR_EQUAL;
                break;
            }
            case IS_DISTINCT_FROM: {
                operatorType = OperatorType.IS_DISTINCT_FROM;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported comparison operator type: " + operator);
            }
        }
        return this.comparisonFunction(operatorType, leftType, rightType);
    }

    public boolean isComparisonFunction(FunctionHandle functionHandle) {
        Optional operatorType = this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType();
        return operatorType.isPresent() && ((OperatorType)operatorType.get()).isComparisonOperator();
    }

    public boolean isEqualsFunction(FunctionHandle functionHandle) {
        Optional operatorType = this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType();
        return operatorType.isPresent() && ((OperatorType)operatorType.get()).getOperator().equals(OperatorType.EQUAL.getOperator());
    }

    public FunctionHandle subscriptFunction(Type baseType, Type indexType) {
        return this.functionAndTypeResolver.lookupFunction(OperatorType.SUBSCRIPT.getFunctionName().getObjectName(), TypeSignatureProvider.fromTypes((Type[])new Type[]{baseType, indexType}));
    }

    public boolean isSubscriptFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.SUBSCRIPT));
    }

    public FunctionHandle tryFunction(Type returnType) {
        return this.functionAndTypeResolver.lookupFunction("$internal$try", TypeSignatureProvider.fromTypes((Type[])new Type[]{returnType}));
    }

    public boolean isTryFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().getObjectName().equals("$internal$try");
    }

    public boolean isFailFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"fail")));
    }

    public boolean isCountFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"count")));
    }

    public FunctionHandle countFunction() {
        return this.functionAndTypeResolver.lookupFunction("count", (List)ImmutableList.of());
    }

    public FunctionHandle countFunction(Type valueType) {
        return this.functionAndTypeResolver.lookupFunction("count", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType}));
    }

    public boolean isMaxFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"max")));
    }

    public FunctionHandle maxFunction(Type valueType) {
        return this.functionAndTypeResolver.lookupFunction("max", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType}));
    }

    public FunctionHandle greatestFunction(List<Type> valueTypes) {
        return this.functionAndTypeResolver.lookupFunction("greatest", TypeSignatureProvider.fromTypes(valueTypes));
    }

    public boolean isMinFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"min")));
    }

    public FunctionHandle minFunction(Type valueType) {
        return this.functionAndTypeResolver.lookupFunction("min", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType}));
    }

    public FunctionHandle leastFunction(List<Type> valueTypes) {
        return this.functionAndTypeResolver.lookupFunction("least", TypeSignatureProvider.fromTypes(valueTypes));
    }

    public boolean isApproximateCountDistinctFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"approx_distinct")));
    }

    public FunctionHandle approximateCountDistinctFunction(Type valueType) {
        return this.functionAndTypeResolver.lookupFunction("approx_distinct", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType}));
    }

    public boolean isApproximateSetFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"approx_set")));
    }

    public FunctionHandle approximateSetFunction(Type valueType) {
        return this.functionAndTypeResolver.lookupFunction("approx_set", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType}));
    }

    public boolean isEqualFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getOperatorType().map(arg_0 -> OperatorType.EQUAL.equals(arg_0)).orElse(false);
    }

    public boolean isArrayContainsFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"contains")));
    }

    public boolean isElementAtFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName().equals((Object)this.functionAndTypeResolver.qualifyObjectName(QualifiedName.of((String)"element_at")));
    }

    public boolean isWindowValueFunction(FunctionHandle functionHandle) {
        return this.windowValueFunctions.contains(this.functionAndTypeResolver.getFunctionMetadata(functionHandle).getName());
    }

    public FunctionHandle lookupBuiltInFunction(String functionName, List<Type> inputTypes) {
        return this.functionAndTypeResolver.lookupFunction(functionName, TypeSignatureProvider.fromTypes(inputTypes));
    }
}

