/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import java.util.Objects;
import java.util.function.Function;

public final class RowExpressionOptimizer
implements ExpressionOptimizer {
    private final FunctionAndTypeManager functionAndTypeManager;

    public RowExpressionOptimizer(Metadata metadata) {
        this(Objects.requireNonNull(metadata, "metadata is null").getFunctionAndTypeManager());
    }

    public RowExpressionOptimizer(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionMetadataManager is null");
    }

    public RowExpression optimize(RowExpression rowExpression, ExpressionOptimizer.Level level, ConnectorSession session) {
        if (level.ordinal() <= ExpressionOptimizer.Level.OPTIMIZED.ordinal()) {
            return LiteralEncoder.toRowExpression(rowExpression.getSourceLocation(), new RowExpressionInterpreter(rowExpression, this.functionAndTypeManager, session, level).optimize(), rowExpression.getType());
        }
        throw new IllegalArgumentException("Not supported optimization level: " + level);
    }

    public RowExpression optimize(RowExpression expression, ExpressionOptimizer.Level level, ConnectorSession session, Function<VariableReferenceExpression, Object> variableResolver) {
        RowExpressionInterpreter interpreter = new RowExpressionInterpreter(expression, this.functionAndTypeManager, session, level);
        return LiteralEncoder.toRowExpression(expression.getSourceLocation(), interpreter.optimize(variableResolver::apply), expression.getType());
    }
}

