/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.UnknownTypeException;
import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.common.type.VarcharEnumType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.DefaultTreeRewriter;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class NativeExecutionTypeRewrite
implements StatementRewrite.Rewrite {
    private static final String FUNCTION_ENUM_KEY = "enum_key";
    private static final String FUNCTION_ELEMENT_AT = "element_at";
    private static final String FUNCTION_MAP = "map";

    NativeExecutionTypeRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector, String query) {
        if (SystemSessionProperties.isNativeExecutionEnabled(session) && SystemSessionProperties.isNativeExecutionTypeRewriteEnabled(session)) {
            return (Statement)new Rewriter(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()).process((Node)node, null);
        }
        return node;
    }

    private static final class Rewriter
    extends DefaultTreeRewriter<Void> {
        private final FunctionAndTypeResolver functionAndTypeResolver;

        public Rewriter(FunctionAndTypeResolver functionAndTypeResolver) {
            this.functionAndTypeResolver = Objects.requireNonNull(functionAndTypeResolver, "functionAndTypeResolver is null");
        }

        protected Node visitCast(Cast node, Void context) {
            try {
                Type type = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)node.getType()));
                if (type instanceof TypeWithName) {
                    type = ((TypeWithName)type).getType();
                    switch (type.getTypeSignature().getBase()) {
                        case "BigintEnum": {
                            return new Cast(node.getLocation(), node.getExpression(), "bigint", node.isSafe(), node.isTypeOnly());
                        }
                        case "VarcharEnum": {
                            return new Cast(node.getLocation(), node.getExpression(), "varchar", node.isSafe(), node.isTypeOnly());
                        }
                    }
                    return new Cast(node.getLocation(), node.getExpression(), type.getTypeSignature().getBase(), node.isSafe(), node.isTypeOnly());
                }
            }
            catch (UnknownTypeException | IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            return node;
        }

        @Override
        protected Node visitFunctionCall(FunctionCall node, Void context) {
            if (this.isValidEnumKeyFunctionCall(node)) {
                Cast argument = (Cast)node.getArguments().get(0);
                Type argumentType = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)argument.getType()));
                if (argumentType instanceof TypeWithName) {
                    argumentType = ((TypeWithName)argumentType).getType();
                }
                if (argumentType instanceof EnumType) {
                    ImmutableList arguments = ImmutableList.of((Object)this.convertEnumTypeToMapExpression(argumentType), (Object)argument.getExpression());
                    return node.getLocation().isPresent() ? new FunctionCall((NodeLocation)node.getLocation().get(), QualifiedName.of((String)NativeExecutionTypeRewrite.FUNCTION_ELEMENT_AT), node.getWindow(), node.getFilter(), node.getOrderBy(), node.isDistinct(), node.isIgnoreNulls(), (List)arguments) : new FunctionCall(QualifiedName.of((String)NativeExecutionTypeRewrite.FUNCTION_ELEMENT_AT), node.getWindow(), node.getFilter(), node.getOrderBy(), node.isDistinct(), node.isIgnoreNulls(), (List)arguments);
                }
            }
            return super.visitFunctionCall(node, context);
        }

        @Override
        protected Node visitExpression(Expression node, Void context) {
            return node;
        }

        private boolean isValidEnumKeyFunctionCall(FunctionCall node) {
            return node.getName().equals((Object)QualifiedName.of((String)NativeExecutionTypeRewrite.FUNCTION_ENUM_KEY)) && node.getArguments().size() == 1 && node.getArguments().get(0) instanceof Cast;
        }

        private Expression convertEnumTypeToMapExpression(Type type) {
            ImmutableList.Builder keys = ImmutableList.builder();
            ImmutableList.Builder values = ImmutableList.builder();
            switch (type.getTypeSignature().getBase()) {
                case "BigintEnum": {
                    for (Map.Entry entry : ((BigintEnumType)type).getEnumMap().entrySet()) {
                        keys.add((Object)new LongLiteral(((Long)entry.getValue()).toString()));
                        values.add((Object)new StringLiteral((String)entry.getKey()));
                    }
                    break;
                }
                case "VarcharEnum": {
                    for (Map.Entry entry : ((VarcharEnumType)type).getEnumMap().entrySet()) {
                        keys.add((Object)new StringLiteral((String)entry.getValue()));
                        values.add((Object)new StringLiteral((String)entry.getKey()));
                    }
                    break;
                }
                default: {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, "Unknown type: " + type, new Object[0]);
                }
            }
            return new FunctionCall(QualifiedName.of((String)NativeExecutionTypeRewrite.FUNCTION_MAP), (List)ImmutableList.of((Object)new ArrayConstructor((List)keys.build()), (Object)new ArrayConstructor((List)values.build())));
        }
    }
}

