/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.ClientRequestFilterManager;
import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.ConnectorTypeSerdeManager;
import com.facebook.presto.connector.system.AnalyzePropertiesSystemTable;
import com.facebook.presto.connector.system.CatalogSystemTable;
import com.facebook.presto.connector.system.ColumnPropertiesSystemTable;
import com.facebook.presto.connector.system.GlobalSystemConnectorFactory;
import com.facebook.presto.connector.system.NodeSystemTable;
import com.facebook.presto.connector.system.SchemaPropertiesSystemTable;
import com.facebook.presto.connector.system.TablePropertiesSystemTable;
import com.facebook.presto.connector.system.TransactionsSystemTable;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostCalculatorUsingExchanges;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.FragmentStatsProvider;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsCalculatorModule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.dispatcher.NoOpQueryManager;
import com.facebook.presto.dispatcher.QueryPrerequisitesManager;
import com.facebook.presto.eventlistener.EventListenerConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.AlterFunctionTask;
import com.facebook.presto.execution.CommitTask;
import com.facebook.presto.execution.CreateFunctionTask;
import com.facebook.presto.execution.CreateMaterializedViewTask;
import com.facebook.presto.execution.CreateTableTask;
import com.facebook.presto.execution.CreateTypeTask;
import com.facebook.presto.execution.CreateViewTask;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.DeallocateTask;
import com.facebook.presto.execution.DropFunctionTask;
import com.facebook.presto.execution.DropMaterializedViewTask;
import com.facebook.presto.execution.DropTableTask;
import com.facebook.presto.execution.DropViewTask;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.PrepareTask;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RenameColumnTask;
import com.facebook.presto.execution.RenameTableTask;
import com.facebook.presto.execution.RenameViewTask;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.execution.RollbackTask;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.SetPropertiesTask;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.execution.StartTransactionTask;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TruncateTableTask;
import com.facebook.presto.execution.resourceGroups.NoOpResourceGroupManager;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.StreamingPlanSection;
import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleTtlNodeSelectorConfig;
import com.facebook.presto.execution.warnings.DefaultWarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.metadata.AnalyzePropertyManager;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.ColumnPropertyManager;
import com.facebook.presto.metadata.ConnectorMetadataUpdaterManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.nodeManager.PluginNodeManager;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.NoOpFragmentResultCacheManager;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.server.ConnectorMetadataUpdateHandleJsonSerde;
import com.facebook.presto.server.NodeStatusNotificationManager;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.server.security.PrestoAuthenticatorManager;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerContext;
import com.facebook.presto.spi.analyzer.AnalyzerOptions;
import com.facebook.presto.spi.analyzer.QueryAnalysis;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.SimplePlanFragment;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spiller.FileSingleStreamSpillerFactory;
import com.facebook.presto.spiller.GenericPartitioningSpillerFactory;
import com.facebook.presto.spiller.GenericSpillerFactory;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.StandaloneSpillerFactory;
import com.facebook.presto.spiller.TempStorageStandaloneSpillerFactory;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.analyzer.AnalyzerProviderManager;
import com.facebook.presto.sql.analyzer.BuiltInAnalyzerProvider;
import com.facebook.presto.sql.analyzer.BuiltInQueryAnalyzer;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparer;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparerProvider;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.sql.analyzer.JavaFeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.QueryPreparerProviderManager;
import com.facebook.presto.sql.expressions.ExpressionOptimizerManager;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.gen.RowExpressionPredicateCompiler;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.JsonCodecSimplePlanFragmentSerde;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.planner.sanity.PlanCheckerProviderManager;
import com.facebook.presto.sql.planner.sanity.PlanCheckerProviderManagerConfig;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.testing.TreeAssertions;
import com.facebook.presto.sql.tree.AlterFunction;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateType;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.DropMaterializedView;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.RenameView;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.SetProperties;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.TruncateTable;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.PageConsumerOperator;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTempStorageManager;
import com.facebook.presto.tracing.TracerProviderManager;
import com.facebook.presto.tracing.TracingConfig;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ThrowingClusterTtlProviderManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.ThrowingNodeTtlFetcherManager;
import com.facebook.presto.util.AnalyzerUtil;
import com.facebook.presto.util.FinalizerService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import io.airlift.units.Duration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.management.MBeanServer;
import org.intellij.lang.annotations.Language;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.testing.TestingMBeanServer;

public class LocalQueryRunner
implements QueryRunner {
    private final Session defaultSession;
    private final ExecutorService notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final FinalizerService finalizerService;
    private final ObjectMapper objectMapper;
    private final SqlParser sqlParser;
    private final PlanFragmenter planFragmenter;
    private final InMemoryNodeManager nodeManager;
    private final PlanCheckerProviderManager planCheckerProviderManager;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final MetadataManager metadata;
    private final ScalarStatsCalculator scalarStatsCalculator;
    private final StatsNormalizer statsNormalizer;
    private final FilterStatsCalculator filterStatsCalculator;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final CostCalculator estimatedExchangesCostCalculator;
    private final TaskCountEstimator taskCountEstimator;
    private final TestingAccessControlManager accessControl;
    private final SplitManager splitManager;
    private final BlockEncodingManager blockEncodingManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final PartitioningProviderManager partitioningProviderManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final ConnectorPlanOptimizerManager planOptimizerManager;
    private final ConnectorMetadataUpdaterManager distributedMetadataManager;
    private final ConnectorTypeSerdeManager connectorTypeSerdeManager;
    private final PageSinkManager pageSinkManager;
    private final TransactionManager transactionManager;
    private final FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private final SpillerFactory spillerFactory;
    private final StandaloneSpillerFactory standaloneSpillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final ExpressionCompiler expressionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final JoinCompiler joinCompiler;
    private final ConnectorManager connectorManager;
    private final HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager;
    private final PluginManager pluginManager;
    private final ImmutableMap<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;
    private final boolean alwaysRevokeMemory;
    private final NodeSpillConfig nodeSpillConfig;
    private final NodeSchedulerConfig nodeSchedulerConfig;
    private final FragmentStatsProvider fragmentStatsProvider;
    private final TaskManagerConfig taskManagerConfig;
    private boolean printPlan;
    private final PlanChecker distributedPlanChecker;
    private final PlanChecker singleNodePlanChecker;
    private final NodeManager pluginNodeManager;
    private static ExecutorService metadataExtractorExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-execution-%s"));
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ExpressionOptimizerManager expressionOptimizerManager;
    private List<PlanOptimizer> additionalOptimizer = ImmutableList.of();

    public LocalQueryRunner(Session defaultSession) {
        this(defaultSession, new FeaturesConfig(), new FunctionsConfig(), new NodeSpillConfig(), false, false);
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, FunctionsConfig functionsConfig) {
        this(defaultSession, featuresConfig, functionsConfig, new NodeSpillConfig(), false, false);
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, FunctionsConfig functionsConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory) {
        this(defaultSession, featuresConfig, functionsConfig, nodeSpillConfig, withInitialTransaction, alwaysRevokeMemory, new ObjectMapper());
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, FunctionsConfig functionsConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory, ObjectMapper objectMapper) {
        this(defaultSession, featuresConfig, functionsConfig, nodeSpillConfig, withInitialTransaction, alwaysRevokeMemory, 1, objectMapper, new TaskManagerConfig().setTaskConcurrency(4));
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, FunctionsConfig functionsConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory, ObjectMapper objectMapper, TaskManagerConfig taskManagerConfig) {
        this(defaultSession, featuresConfig, functionsConfig, nodeSpillConfig, withInitialTransaction, alwaysRevokeMemory, 1, objectMapper, taskManagerConfig);
    }

    private LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, FunctionsConfig functionsConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory, int nodeCountForStats, ObjectMapper objectMapper, TaskManagerConfig taskManagerConfig) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() || !withInitialTransaction ? 1 : 0) != 0, (Object)"Already in transaction");
        this.taskManagerConfig = taskManagerConfig;
        this.nodeSpillConfig = Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
        this.alwaysRevokeMemory = alwaysRevokeMemory;
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.sqlParser = new SqlParser();
        this.nodeManager = new InMemoryNodeManager();
        this.pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
        this.indexManager = new IndexManager();
        this.nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(true);
        NodeScheduler nodeScheduler = new NodeScheduler(new LegacyNetworkTopology(), this.nodeManager, new NodeSelectionStats(), this.nodeSchedulerConfig, new NodeTaskMap(this.finalizerService), new ThrowingNodeTtlFetcherManager(), new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        this.pageSinkManager = new PageSinkManager();
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.create(new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.DAYS)), this.yieldExecutor, catalogManager, this.notificationExecutor);
        this.partitioningProviderManager = new PartitioningProviderManager();
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler, this.partitioningProviderManager, new NodeSelectionStats());
        this.planOptimizerManager = new ConnectorPlanOptimizerManager();
        this.distributedMetadataManager = new ConnectorMetadataUpdaterManager();
        this.connectorTypeSerdeManager = new ConnectorTypeSerdeManager(new ConnectorMetadataUpdateHandleJsonSerde());
        this.blockEncodingManager = new BlockEncodingManager();
        featuresConfig.setIgnoreStatsCalculatorFailures(false);
        this.metadata = new MetadataManager(new FunctionAndTypeManager(this.transactionManager, (BlockEncodingSerde)this.blockEncodingManager, featuresConfig, functionsConfig, new HandleResolver(), (Set<Type>)ImmutableSet.of()), (BlockEncodingSerde)this.blockEncodingManager, SessionPropertyManager.createTestingSessionPropertyManager(new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), featuresConfig, functionsConfig, new NodeMemoryConfig(), new WarningCollectorConfig(), new NodeSchedulerConfig(), new NodeSpillConfig(), new TracingConfig(), new CompilerConfig(), new HistoryBasedOptimizationConfig()).getSessionProperties(), new JavaFeaturesConfig(), nodeSpillConfig), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), new AnalyzePropertyManager(), this.transactionManager);
        this.splitManager = new SplitManager(this.metadata, new QueryManagerConfig(), this.nodeSchedulerConfig);
        this.planCheckerProviderManager = new PlanCheckerProviderManager(new JsonCodecSimplePlanFragmentSerde((JsonCodec<SimplePlanFragment>)JsonCodec.jsonCodec(SimplePlanFragment.class)), new PlanCheckerProviderManagerConfig());
        this.distributedPlanChecker = new PlanChecker(featuresConfig, false, this.planCheckerProviderManager);
        this.singleNodePlanChecker = new PlanChecker(featuresConfig, true, this.planCheckerProviderManager);
        this.planFragmenter = new PlanFragmenter(this.metadata, this.nodePartitioningManager, new QueryManagerConfig(), featuresConfig, this.planCheckerProviderManager);
        this.joinCompiler = new JoinCompiler(this.metadata);
        this.pageIndexerFactory = new GroupByHashPageIndexerFactory(this.joinCompiler);
        NodeInfo nodeInfo = new NodeInfo("test");
        this.expressionOptimizerManager = new ExpressionOptimizerManager(new PluginNodeManager(this.nodeManager, nodeInfo.getEnvironment()), this.getFunctionAndTypeManager());
        this.accessControl = new TestingAccessControlManager(this.transactionManager);
        this.statsNormalizer = new StatsNormalizer();
        this.scalarStatsCalculator = new ScalarStatsCalculator((Metadata)this.metadata, this.expressionOptimizerManager);
        this.filterStatsCalculator = new FilterStatsCalculator(this.metadata, this.scalarStatsCalculator, this.statsNormalizer);
        this.historyBasedPlanStatisticsManager = new HistoryBasedPlanStatisticsManager(objectMapper, SessionPropertyManager.createTestingSessionPropertyManager(), this.metadata, new HistoryBasedOptimizationConfig(), featuresConfig, new NodeVersion("1"));
        this.fragmentStatsProvider = new FragmentStatsProvider();
        this.statsCalculator = StatsCalculatorModule.createNewStatsCalculator(this.metadata, this.scalarStatsCalculator, this.statsNormalizer, this.filterStatsCalculator, this.historyBasedPlanStatisticsManager, this.fragmentStatsProvider);
        this.taskCountEstimator = new TaskCountEstimator(() -> nodeCountForStats);
        this.costCalculator = new CostCalculatorUsingExchanges(this.taskCountEstimator);
        this.estimatedExchangesCostCalculator = new CostCalculatorWithEstimatedExchanges(this.costCalculator, this.taskCountEstimator);
        this.pageSourceManager = new PageSourceManager();
        this.pageFunctionCompiler = new PageFunctionCompiler((Metadata)this.metadata, 0);
        this.expressionCompiler = new ExpressionCompiler(this.metadata, this.pageFunctionCompiler);
        this.joinFilterFunctionCompiler = new JoinFilterFunctionCompiler(this.metadata);
        this.pluginNodeManager = new PluginNodeManager(this.nodeManager, "test");
        NodeVersion nodeVersion = new NodeVersion("testversion");
        this.connectorManager = new ConnectorManager(this.metadata, catalogManager, this.accessControl, this.splitManager, this.pageSourceManager, this.indexManager, this.partitioningProviderManager, this.planOptimizerManager, this.distributedMetadataManager, this.connectorTypeSerdeManager, this.pageSinkManager, new HandleResolver(), this.nodeManager, nodeInfo, this.metadata.getFunctionAndTypeManager(), this.pageSorter, this.pageIndexerFactory, this.transactionManager, this.expressionOptimizerManager, new RowExpressionDomainTranslator(this.metadata), new RowExpressionPredicateCompiler(this.metadata), new RowExpressionDeterminismEvaluator(this.metadata.getFunctionAndTypeManager()), new FilterStatsCalculator(this.metadata, this.scalarStatsCalculator, this.statsNormalizer), (BlockEncodingSerde)this.blockEncodingManager, featuresConfig);
        GlobalSystemConnectorFactory globalSystemConnectorFactory = new GlobalSystemConnectorFactory((Set<SystemTable>)ImmutableSet.of((Object)new NodeSystemTable(this.nodeManager), (Object)new CatalogSystemTable(this.metadata, this.accessControl), (Object)new SchemaPropertiesSystemTable(this.transactionManager, this.metadata), (Object)new TablePropertiesSystemTable(this.transactionManager, this.metadata), (Object)new ColumnPropertiesSystemTable(this.transactionManager, this.metadata), (Object)new AnalyzePropertiesSystemTable(this.transactionManager, this.metadata), (Object[])new SystemTable[]{new TransactionsSystemTable(this.metadata.getFunctionAndTypeManager(), this.transactionManager)}), (Set<Procedure>)ImmutableSet.of());
        BuiltInQueryAnalyzer queryAnalyzer = new BuiltInQueryAnalyzer(this.metadata, this.sqlParser, this.accessControl, Optional.empty(), metadataExtractorExecutor);
        BuiltInAnalyzerProvider analyzerProvider = new BuiltInAnalyzerProvider(queryAnalyzer);
        BuiltInQueryPreparer queryPreparer = new BuiltInQueryPreparer(this.sqlParser);
        BuiltInQueryPreparerProvider queryPreparerProvider = new BuiltInQueryPreparerProvider(queryPreparer);
        this.pluginManager = new PluginManager(nodeInfo, new PluginManagerConfig(), this.connectorManager, this.metadata, new NoOpResourceGroupManager(), new AnalyzerProviderManager(analyzerProvider), new QueryPreparerProviderManager(queryPreparerProvider), this.accessControl, new PasswordAuthenticatorManager(), new PrestoAuthenticatorManager(new SecurityConfig()), new EventListenerManager(new EventListenerConfig()), this.blockEncodingManager, new TestingTempStorageManager(), new QueryPrerequisitesManager(), new SessionPropertyDefaults(nodeInfo, nodeVersion), new ThrowingNodeTtlFetcherManager(), new ThrowingClusterTtlProviderManager(), this.historyBasedPlanStatisticsManager, new TracerProviderManager(new TracingConfig()), new NodeStatusNotificationManager(), new ClientRequestFilterManager(), this.planCheckerProviderManager, this.expressionOptimizerManager);
        this.connectorManager.addConnectorFactory(globalSystemConnectorFactory);
        this.connectorManager.createConnection("system", "system", (Map<String, String>)ImmutableMap.of());
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog("testing_catalog"));
        this.defaultSession = new Session(defaultSession.getQueryId(), withInitialTransaction ? Optional.of(this.transactionManager.beginTransaction(false)) : defaultSession.getTransactionId(), defaultSession.isClientTransactionSupport(), defaultSession.getIdentity(), defaultSession.getSource(), defaultSession.getCatalog(), defaultSession.getSchema(), defaultSession.getTraceToken(), defaultSession.getTimeZoneKey(), defaultSession.getLocale(), defaultSession.getRemoteUserAddress(), defaultSession.getUserAgent(), defaultSession.getClientInfo(), defaultSession.getClientTags(), defaultSession.getResourceEstimates(), defaultSession.getStartTime(), defaultSession.getSystemProperties(), defaultSession.getConnectorProperties(), defaultSession.getUnprocessedCatalogProperties(), this.metadata.getSessionPropertyManager(), defaultSession.getPreparedStatements(), defaultSession.getSessionFunctions(), defaultSession.getTracer(), defaultSession.getWarningCollector(), defaultSession.getRuntimeStats(), defaultSession.getQueryType());
        this.dataDefinitionTask = ImmutableMap.builder().put(CreateTable.class, (Object)new CreateTableTask()).put(CreateView.class, (Object)new CreateViewTask((JsonCodec<ViewDefinition>)JsonCodec.jsonCodec(ViewDefinition.class), this.sqlParser, new FeaturesConfig())).put(CreateMaterializedView.class, (Object)new CreateMaterializedViewTask(this.sqlParser)).put(CreateType.class, (Object)new CreateTypeTask(this.sqlParser)).put(CreateFunction.class, (Object)new CreateFunctionTask(this.sqlParser)).put(AlterFunction.class, (Object)new AlterFunctionTask(this.sqlParser)).put(DropFunction.class, (Object)new DropFunctionTask(this.sqlParser)).put(DropTable.class, (Object)new DropTableTask()).put(DropView.class, (Object)new DropViewTask()).put(TruncateTable.class, (Object)new TruncateTableTask()).put(DropMaterializedView.class, (Object)new DropMaterializedViewTask()).put(RenameColumn.class, (Object)new RenameColumnTask()).put(RenameTable.class, (Object)new RenameTableTask()).put(RenameView.class, (Object)new RenameViewTask()).put(ResetSession.class, (Object)new ResetSessionTask()).put(SetSession.class, (Object)new SetSessionTask()).put(Prepare.class, (Object)new PrepareTask(this.sqlParser)).put(Deallocate.class, (Object)new DeallocateTask()).put(StartTransaction.class, (Object)new StartTransactionTask()).put(Commit.class, (Object)new CommitTask()).put(Rollback.class, (Object)new RollbackTask()).put(SetProperties.class, (Object)new SetPropertiesTask()).build();
        SpillerStats spillerStats = new SpillerStats();
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory((BlockEncodingSerde)this.blockEncodingManager, spillerStats, featuresConfig, nodeSpillConfig);
        this.partitioningSpillerFactory = new GenericPartitioningSpillerFactory(this.singleStreamSpillerFactory);
        this.spillerFactory = new GenericSpillerFactory(this.singleStreamSpillerFactory);
        this.standaloneSpillerFactory = new TempStorageStandaloneSpillerFactory(new TestingTempStorageManager(), (BlockEncodingSerde)this.blockEncodingManager, nodeSpillConfig, featuresConfig, spillerStats);
    }

    public static LocalQueryRunner queryRunnerWithInitialTransaction(Session defaultSession) {
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() ? 1 : 0) != 0, (Object)"Already in transaction!");
        return new LocalQueryRunner(defaultSession, new FeaturesConfig(), new FunctionsConfig(), new NodeSpillConfig(), true, false);
    }

    public static LocalQueryRunner queryRunnerWithFakeNodeCountForStats(Session defaultSession, int nodeCount) {
        return new LocalQueryRunner(defaultSession, new FeaturesConfig(), new FunctionsConfig(), new NodeSpillConfig(), false, false, nodeCount, new ObjectMapper(), new TaskManagerConfig().setTaskConcurrency(4));
    }

    @Override
    public void close() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.connectorManager.stop();
        this.finalizerService.destroy();
        this.singleStreamSpillerFactory.destroy();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    public FunctionAndTypeManager getFunctionAndTypeManager() {
        return this.metadata.getFunctionAndTypeManager();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    @Override
    public ConnectorPlanOptimizerManager getPlanOptimizerManager() {
        return this.planOptimizerManager;
    }

    @Override
    public PlanCheckerProviderManager getPlanCheckerProviderManager() {
        return this.planCheckerProviderManager;
    }

    @Override
    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    @Override
    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public FragmentStatsProvider getFragmentStatsProvider() {
        return this.fragmentStatsProvider;
    }

    @Override
    public StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    @Override
    public List<EventListener> getEventListeners() {
        return ImmutableList.of();
    }

    public CostCalculator getCostCalculator() {
        return this.costCalculator;
    }

    public CostCalculator getEstimatedExchangesCostCalculator() {
        return this.estimatedExchangesCostCalculator;
    }

    @Override
    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    @Override
    public ExpressionOptimizerManager getExpressionManager() {
        return this.expressionOptimizerManager;
    }

    public ExecutorService getExecutor() {
        return this.notificationExecutor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.yieldExecutor;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public ExpressionCompiler getExpressionCompiler() {
        return this.expressionCompiler;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeConnector(new ConnectorId(catalogName));
        this.connectorManager.addConnectorFactory(connectorFactory);
        this.connectorManager.createConnection(catalogName, connectorFactory.getName(), properties);
    }

    @Override
    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin);
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties) {
        this.metadata.getFunctionAndTypeManager().loadFunctionNamespaceManager(functionNamespaceManagerName, catalogName, properties, this.pluginNodeManager);
    }

    public LocalQueryRunner printPlan() {
        this.printPlan = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List list = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> this.getMetadata().listTables((Session)transactionSession, new QualifiedTablePrefix(catalog, schema)));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> MetadataUtil.tableExists(this.getMetadata(), transactionSession, table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    @Override
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.executeWithPlan(session, sql, new DefaultWarningCollector(new WarningCollectorConfig(), SystemSessionProperties.getWarningHandlingLevel(session))).getMaterializedResult();
    }

    @Override
    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        return this.inTransaction(session, transactionSession -> this.executeInternal((Session)transactionSession, sql, warningCollector));
    }

    public <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return this.inTransaction(this.defaultSession, transactionSessionConsumer);
    }

    public <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return TransactionBuilder.transaction(this.transactionManager, this.accessControl).singleStatement().execute(session, transactionSessionConsumer);
    }

    private QueryRunner.MaterializedResultWithPlan executeInternal(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        if (this.isExplainTypeValidate(sql, session, warningCollector)) {
            return this.executeExplainTypeValidate(sql, session, warningCollector);
        }
        this.lock.readLock().lock();
        try {
            QueryRunner.MaterializedResultWithPlan materializedResultWithPlan;
            block15: {
                Closer closer = Closer.create();
                try {
                    AtomicReference builder = new AtomicReference();
                    PageConsumerOperator.PageConsumerOutputFactory outputFactory = new PageConsumerOperator.PageConsumerOutputFactory(types -> {
                        builder.compareAndSet(null, MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)types));
                        return ((MaterializedResult.Builder)builder.get())::page;
                    });
                    Plan plan = this.createPlan(session, sql, warningCollector);
                    TaskContext taskContext = TestingTaskContext.builder(this.notificationExecutor, this.yieldExecutor, session).setMaxSpillSize(this.nodeSpillConfig.getMaxSpillPerNode()).setQueryMaxSpillSize(this.nodeSpillConfig.getQueryMaxSpillPerNode()).setQueryMaxTotalMemory(SystemSessionProperties.getQueryMaxTotalMemoryPerNode(session)).setTaskPlan(plan.getRoot()).build();
                    taskContext.getQueryContext().setVerboseExceededMemoryLimitErrorsEnabled(SystemSessionProperties.isVerboseExceededMemoryLimitErrorsEnabled(session));
                    taskContext.getQueryContext().setHeapDumpOnExceededMemoryLimitEnabled(SystemSessionProperties.isHeapDumpOnExceededMemoryLimitEnabled(session));
                    String heapDumpFilePath = Paths.get(SystemSessionProperties.getHeapDumpFileDirectory(session), String.format("%s_%s.hprof", session.getQueryId().getId(), taskContext.getTaskId().getStageExecutionId().getStageId().getId())).toString();
                    taskContext.getQueryContext().setHeapDumpFilePath(heapDumpFilePath);
                    List<Driver> drivers = this.createDrivers(session, plan, (OutputFactory)outputFactory, taskContext);
                    drivers.forEach(arg_0 -> ((Closer)closer).register(arg_0));
                    boolean done = false;
                    while (!done) {
                        boolean processed = false;
                        for (Driver driver : drivers) {
                            if (this.alwaysRevokeMemory) {
                                driver.getDriverContext().getOperatorContexts().stream().filter(operatorContext -> operatorContext.getOperatorStats().getRevocableMemoryReservationInBytes() > 0L).forEach(OperatorContext::requestMemoryRevoking);
                            }
                            if (driver.isFinished()) continue;
                            driver.process();
                            processed = true;
                        }
                        done = !processed;
                    }
                    Verify.verify((builder.get() != null ? 1 : 0) != 0, (String)"Output operator was not created", (Object[])new Object[0]);
                    materializedResultWithPlan = new QueryRunner.MaterializedResultWithPlan(((MaterializedResult.Builder)builder.get()).build(), plan);
                    if (closer == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (closer != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                closer.close();
            }
            return materializedResultWithPlan;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private QueryRunner.MaterializedResultWithPlan executeExplainTypeValidate(String sql, Session session, WarningCollector warningCollector) {
        AnalyzerOptions analyzerOptions = AnalyzerUtil.createAnalyzerOptions(session, warningCollector);
        BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery = new BuiltInQueryPreparer(this.sqlParser).prepareQuery(analyzerOptions, sql, session.getPreparedStatements(), warningCollector);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)AnalyzerUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        QueryExplainer queryExplainer = new QueryExplainer(this.getPlanOptimizers(true), this.planFragmenter, (Metadata)this.metadata, (AccessControl)this.accessControl, this.sqlParser, this.statsCalculator, this.costCalculator, (Map<Class<? extends Statement>, DataDefinitionTask<?>>)this.dataDefinitionTask, this.distributedPlanChecker);
        BuiltInQueryAnalyzer queryAnalyzer = new BuiltInQueryAnalyzer(this.metadata, this.sqlParser, this.accessControl, Optional.of(queryExplainer), metadataExtractorExecutor);
        AnalyzerContext analyzerContext = AnalyzerUtil.getAnalyzerContext(queryAnalyzer, this.metadata.getMetadataResolver(session), idAllocator, new VariableAllocator(), session, sql);
        QueryAnalysis queryAnalysis = queryAnalyzer.analyze(analyzerContext, (PreparedQuery)preparedQuery);
        AnalyzerUtil.checkAccessPermissions(queryAnalysis.getAccessControlReferences(), sql);
        MaterializedResult result = MaterializedResult.resultBuilder(session, new Type[]{BooleanType.BOOLEAN}).row(true).build();
        return new QueryRunner.MaterializedResultWithPlan(result, null);
    }

    private boolean isExplainTypeValidate(String sql, Session session, WarningCollector warningCollector) {
        AnalyzerOptions analyzerOptions = AnalyzerUtil.createAnalyzerOptions(session, warningCollector);
        BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery = new BuiltInQueryPreparer(this.sqlParser).prepareQuery(analyzerOptions, sql, session.getPreparedStatements(), warningCollector);
        return preparedQuery.isExplainTypeValidate();
    }

    @Override
    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public List<Driver> createDrivers(@Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        return this.createDrivers(this.defaultSession, sql, outputFactory, taskContext);
    }

    public List<Driver> createDrivers(Session session, @Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        Plan plan = this.createPlan(session, sql, WarningCollector.NOOP);
        return this.createDrivers(session, plan, outputFactory, taskContext);
    }

    private List<Driver> createDrivers(Session session, Plan plan, OutputFactory outputFactory, TaskContext taskContext) {
        SubPlan subplan;
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), plan.getStatsAndCosts(), this.metadata.getFunctionAndTypeManager(), session, 0, false, SystemSessionProperties.isVerboseOptimizerInfoEnabled(session)));
        }
        if (!(subplan = this.createSubPlans(session, plan, true)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected subplan to have no children");
        }
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(this.metadata, Optional.empty(), this.pageSourceManager, this.indexManager, this.partitioningProviderManager, this.nodePartitioningManager, this.pageSinkManager, this.distributedMetadataManager, this.expressionCompiler, this.pageFunctionCompiler, this.joinFilterFunctionCompiler, new IndexJoinLookupStats(), this.taskManagerConfig, new MemoryManagerConfig(), new FunctionsConfig(), this.spillerFactory, this.singleStreamSpillerFactory, this.partitioningSpillerFactory, (BlockEncodingSerde)this.blockEncodingManager, new PagesIndex.TestingFactory(false), this.joinCompiler, new LookupJoinOperators(), new OrderingCompiler(), (JsonCodec<TableCommitContext>)JsonCodec.jsonCodec(TableCommitContext.class), new RowExpressionDeterminismEvaluator(this.metadata), new NoOpFragmentResultCacheManager(), this.objectMapper, this.standaloneSpillerFactory);
        StageExecutionDescriptor stageExecutionDescriptor = subplan.getFragment().getStageExecutionDescriptor();
        StreamingPlanSection streamingPlanSection = StreamingPlanSection.extractStreamingSections(subplan);
        Preconditions.checkState((boolean)streamingPlanSection.getChildren().isEmpty(), (Object)"expected no materialized exchanges");
        StreamingSubPlan streamingSubPlan = streamingPlanSection.getPlan();
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(taskContext, subplan.getFragment(), outputFactory, Optional.empty(), new UnsupportedRemoteSourceFactory(), TableWriteInfo.createTableWriteInfo(streamingSubPlan, (Metadata)this.metadata, session), false, (List<LocalExecutionPlanner.CustomPlanTranslator>)ImmutableList.of());
        ArrayList<TaskSource> sources = new ArrayList<TaskSource>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : LocalQueryRunner.findTableScanNodes(subplan.getFragment().getRoot())) {
            SplitSource splitSource = this.splitManager.getSplits(session, tableScan.getTable(), LocalQueryRunner.getSplitSchedulingStrategy(stageExecutionDescriptor, tableScan.getId()), WarningCollector.NOOP);
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : LocalQueryRunner.getNextBatch(splitSource)) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, tableScan.getId(), split));
                }
            }
            sources.add(new TaskSource(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, DriverFactory> driverFactoriesBySource = new HashMap<PlanNodeId, DriverFactory>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                if (driverFactory.getSourceId().isPresent()) {
                    Preconditions.checkState((driverFactoriesBySource.put(driverFactory.getSourceId().get(), driverFactory) == null ? 1 : 0) != 0);
                    continue;
                }
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), false).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
            }
        }
        ImmutableSet tableScanPlanNodeIds = ImmutableSet.copyOf(subplan.getFragment().getTableScanSchedulingOrder());
        for (TaskSource source : sources) {
            DriverFactory driverFactory = (DriverFactory)driverFactoriesBySource.get(source.getPlanNodeId());
            Preconditions.checkState((driverFactory != null ? 1 : 0) != 0);
            boolean partitioned = tableScanPlanNodeIds.contains(driverFactory.getSourceId().get());
            for (ScheduledSplit split : source.getSplits()) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                driver.updateSource(new TaskSource(split.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)split), true));
                drivers.add(driver);
            }
        }
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            driverFactory.noMoreDrivers();
        }
        return ImmutableList.copyOf(drivers);
    }

    private static ConnectorSplitManager.SplitSchedulingStrategy getSplitSchedulingStrategy(StageExecutionDescriptor stageExecutionDescriptor, PlanNodeId scanNodeId) {
        if (stageExecutionDescriptor.isRecoverableGroupedExecution()) {
            return ConnectorSplitManager.SplitSchedulingStrategy.REWINDABLE_GROUPED_SCHEDULING;
        }
        if (stageExecutionDescriptor.isScanGroupedExecution(scanNodeId)) {
            return ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING;
        }
        return ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING;
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean noExchange) {
        return this.planFragmenter.createSubPlans(session, plan, noExchange, new PlanNodeIdAllocator(){

            public PlanNodeId getNextId() {
                throw new UnsupportedOperationException();
            }
        }, WarningCollector.NOOP);
    }

    @Override
    public Plan createPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        return this.createPlan(session, sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, Optimizer.PlanStage stage, WarningCollector warningCollector) {
        return this.createPlan(session, sql, stage, true, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, Optimizer.PlanStage stage, boolean noExchange, WarningCollector warningCollector) {
        AnalyzerOptions analyzerOptions = AnalyzerUtil.createAnalyzerOptions(session, warningCollector);
        BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery = new BuiltInQueryPreparer(this.sqlParser).prepareQuery(analyzerOptions, sql, session.getPreparedStatements(), warningCollector);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)AnalyzerUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        return this.createPlan(session, sql, this.getPlanOptimizers(noExchange), stage, warningCollector);
    }

    public void setAdditionalOptimizer(List<PlanOptimizer> additionalOptimizer) {
        this.additionalOptimizer = additionalOptimizer;
    }

    public List<PlanOptimizer> getPlanOptimizers(boolean noExchange) {
        FeaturesConfig featuresConfig = new FeaturesConfig().setDistributedIndexJoinsEnabled(false).setOptimizeHashGeneration(true);
        ImmutableList.Builder planOptimizers = ImmutableList.builder();
        if (!this.additionalOptimizer.isEmpty()) {
            planOptimizers.addAll(this.additionalOptimizer);
        }
        planOptimizers.addAll(new PlanOptimizers(this.metadata, this.sqlParser, noExchange, new MBeanExporter((MBeanServer)new TestingMBeanServer()), this.splitManager, this.planOptimizerManager, this.pageSourceManager, this.statsCalculator, this.costCalculator, this.estimatedExchangesCostCalculator, new CostComparator(featuresConfig), this.taskCountEstimator, this.partitioningProviderManager, featuresConfig, this.expressionOptimizerManager, this.taskManagerConfig).getPlanningTimeOptimizers());
        return planOptimizers.build();
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, WarningCollector warningCollector) {
        return this.createPlan(session, sql, optimizers, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, Optimizer.PlanStage stage, WarningCollector warningCollector) {
        AnalyzerOptions analyzerOptions = AnalyzerUtil.createAnalyzerOptions(session, warningCollector);
        BuiltInQueryPreparer.BuiltInPreparedQuery preparedQuery = new BuiltInQueryPreparer(this.sqlParser).prepareQuery(analyzerOptions, sql, session.getPreparedStatements(), warningCollector);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)AnalyzerUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        QueryExplainer queryExplainer = new QueryExplainer(optimizers, this.planFragmenter, (Metadata)this.metadata, (AccessControl)this.accessControl, this.sqlParser, this.statsCalculator, this.costCalculator, (Map<Class<? extends Statement>, DataDefinitionTask<?>>)this.dataDefinitionTask, this.distributedPlanChecker);
        BuiltInQueryAnalyzer queryAnalyzer = new BuiltInQueryAnalyzer(this.metadata, this.sqlParser, this.accessControl, Optional.of(queryExplainer), metadataExtractorExecutor);
        AnalyzerContext analyzerContext = AnalyzerUtil.getAnalyzerContext(queryAnalyzer, this.metadata.getMetadataResolver(session), idAllocator, new VariableAllocator(), session, sql);
        QueryAnalysis queryAnalysis = queryAnalyzer.analyze(analyzerContext, (PreparedQuery)preparedQuery);
        AnalyzerUtil.checkAccessPermissions(queryAnalysis.getAccessControlReferences(), sql);
        PlanNode planNode = (PlanNode)session.getRuntimeStats().recordWallAndCpuTime("logicalPlannerTimeNanos", () -> queryAnalyzer.plan(analyzerContext, queryAnalysis));
        Optimizer optimizer = new Optimizer(session, this.metadata, optimizers, this.singleNodePlanChecker, analyzerContext.getVariableAllocator(), idAllocator, warningCollector, this.statsCalculator, this.costCalculator, preparedQuery.getWrappedStatement() instanceof Explain);
        return (Plan)session.getRuntimeStats().recordWallAndCpuTime("optimizerTimeNanos", () -> optimizer.validateAndOptimizePlan(planNode, stage));
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000))).getSplits();
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        return PlanNodeSearcher.searchFrom(node).where(TableScanNode.class::isInstance).findAll();
    }

    private static class UnsupportedRemoteSourceFactory
    implements RemoteSourceFactory {
        private UnsupportedRemoteSourceFactory() {
        }

        @Override
        public SourceOperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SourceOperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
            throw new UnsupportedOperationException();
        }
    }
}

