/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.eventlistener.EventListenerConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryProgressEvent;
import com.facebook.presto.spi.eventlistener.QueryUpdatedEvent;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class TestingEventListenerManager
extends EventListenerManager {
    private final AtomicReference<List<EventListener>> configuredEventListeners = new AtomicReference<ImmutableList>(ImmutableList.of());

    @Inject
    public TestingEventListenerManager(EventListenerConfig config) {
        super(config);
    }

    @Override
    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        this.configuredEventListeners.set((List<EventListener>)ImmutableList.of((Object)eventListenerFactory.create((Map)ImmutableMap.of())));
    }

    @Override
    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.queryCompleted(queryCompletedEvent));
    }

    @Override
    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.queryCreated(queryCreatedEvent));
    }

    @Override
    public void queryUpdated(QueryUpdatedEvent queryUpdatedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.queryUpdated(queryUpdatedEvent));
    }

    @Override
    public void publishQueryProgress(QueryProgressEvent queryProgressEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.publishQueryProgress(queryProgressEvent));
    }

    @Override
    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.splitCompleted(splitCompletedEvent));
    }

    public List<EventListener> getEventListeners() {
        return this.configuredEventListeners.get();
    }
}

