/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.presto.Session;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.metadata.CatalogMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DelegatingTransactionManager
implements TransactionManager {
    private final TransactionManager delegate;

    public TransactionManager getDelegate() {
        return this.delegate;
    }

    public DelegatingTransactionManager(TransactionManager delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public TransactionInfo getTransactionInfo(TransactionId transactionId) {
        return this.delegate.getTransactionInfo(transactionId);
    }

    @Override
    public Optional<TransactionInfo> getOptionalTransactionInfo(TransactionId transactionId) {
        return this.delegate.getOptionalTransactionInfo(transactionId);
    }

    @Override
    public List<TransactionInfo> getAllTransactionInfos() {
        return this.delegate.getAllTransactionInfos();
    }

    @Override
    public void tryRegisterTransaction(TransactionInfo transactionInfo) {
        this.delegate.tryRegisterTransaction(transactionInfo);
    }

    @Override
    public TransactionId beginTransaction(boolean autoCommitContext) {
        return this.delegate.beginTransaction(autoCommitContext);
    }

    @Override
    public TransactionId beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext) {
        return this.delegate.beginTransaction(isolationLevel, readOnly, autoCommitContext);
    }

    @Override
    public Map<String, ConnectorId> getCatalogNames(TransactionId transactionId) {
        return this.delegate.getCatalogNames(transactionId);
    }

    @Override
    public Optional<CatalogMetadata> getOptionalCatalogMetadata(TransactionId transactionId, String catalogName) {
        return this.delegate.getOptionalCatalogMetadata(transactionId, catalogName);
    }

    @Override
    public void enableRollback(TransactionId transactionId) {
        this.delegate.enableRollback(transactionId);
    }

    @Override
    public CatalogMetadata getCatalogMetadata(TransactionId transactionId, ConnectorId connectorId) {
        return this.delegate.getCatalogMetadata(transactionId, connectorId);
    }

    @Override
    public CatalogMetadata getCatalogMetadataForWrite(TransactionId transactionId, ConnectorId connectorId) {
        return this.delegate.getCatalogMetadataForWrite(transactionId, connectorId);
    }

    @Override
    public CatalogMetadata getCatalogMetadataForWrite(TransactionId transactionId, String catalogName) {
        return this.delegate.getCatalogMetadataForWrite(transactionId, catalogName);
    }

    @Override
    public ConnectorTransactionHandle getConnectorTransaction(TransactionId transactionId, ConnectorId connectorId) {
        return this.delegate.getConnectorTransaction(transactionId, connectorId);
    }

    @Override
    public void checkAndSetActive(TransactionId transactionId) {
        this.delegate.checkAndSetActive(transactionId);
    }

    @Override
    public void trySetActive(TransactionId transactionId) {
        this.delegate.trySetActive(transactionId);
    }

    @Override
    public void trySetInactive(TransactionId transactionId) {
        this.delegate.trySetInactive(transactionId);
    }

    @Override
    public ListenableFuture<?> asyncCommit(TransactionId transactionId) {
        return this.delegate.asyncCommit(transactionId);
    }

    @Override
    public ListenableFuture<?> asyncAbort(TransactionId transactionId) {
        return this.delegate.asyncAbort(transactionId);
    }

    @Override
    public void fail(TransactionId transactionId) {
        this.delegate.fail(transactionId);
    }

    @Override
    public void activateTransaction(Session session, boolean transactionControl, AccessControl accessControl) {
        this.delegate.activateTransaction(session, transactionControl, accessControl);
    }

    @Override
    public void registerFunctionNamespaceManager(String catalogName, FunctionNamespaceManager<?> functionNamespaceManager) {
        this.delegate.registerFunctionNamespaceManager(catalogName, functionNamespaceManager);
    }

    @Override
    public FunctionNamespaceTransactionHandle getFunctionNamespaceTransaction(TransactionId transactionId, String catalogName) {
        return this.delegate.getFunctionNamespaceTransaction(transactionId, catalogName);
    }
}

