/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.client.IntervalDayTime;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.AbstractLongType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.IntervalDayTimeType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class IntervalDayTimeOperators {
    private IntervalDayTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval day to second")
    public static long add(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        try {
            return Math.addExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("interval_day_to_second addition overflow: %s ms + %s ms", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        try {
            return Math.subtractExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("interval_day_to_second subtraction overflow: %s ms - %s ms", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByBigint(@SqlType(value="interval day to second") long left, @SqlType(value="bigint") long right) {
        try {
            return Math.multiplyExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("interval_day_to_second multiply overflow: %s ms * %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        try {
            return Math.addExact((long)((double)left * (right - (double)((long)right))), Math.multiplyExact(left, (long)right));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("interval_day_to_second multiply overflow: %s ms * %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long bigintMultiply(@SqlType(value="bigint") long left, @SqlType(value="interval day to second") long right) {
        try {
            return Math.multiplyExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("interval_day_to_second multiply overflow: %s * %s ms", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval day to second") long right) {
        try {
            return Math.addExact(Math.multiplyExact((long)left, right), (long)((left - (double)((long)left)) * (double)right));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("interval_day_to_second multiply overflow: %s * %s ms", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval day to second")
    public static long divideByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        if (right == 0.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, String.format("interval_day_to_second division by zero: %s ms / %s", left, right));
        }
        try {
            return IntervalDayTimeOperators.multiplyByDouble(left, 1.0 / right);
        }
        catch (PrestoException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("interval_day_to_second division overflow: %s ms / %s", left, right));
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval day to second")
    public static long negate(@SqlType(value="interval day to second") long value) {
        try {
            return Math.negateExact(value);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "interval_day_to_second negation overflow: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="interval day to second") long value, @SqlType(value="interval day to second") long min, @SqlType(value="interval day to second") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(@SqlType(value="interval day to second") long value) {
        return Slices.utf8Slice((String)IntervalDayTime.formatMillis((long)value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="interval day to second") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="interval day to second") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class IntervalDayTimeDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="interval day to second") long left, @IsNull boolean leftNull, @SqlType(value="interval day to second") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return IntervalDayTimeOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="interval day to second", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="interval day to second", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return IntervalDayTimeOperators.notEqual(IntervalDayTimeType.INTERVAL_DAY_TIME.getLong(left, leftPosition), IntervalDayTimeType.INTERVAL_DAY_TIME.getLong(right, rightPosition));
        }
    }
}

