/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.client.IntervalYearMonth;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.AbstractIntType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.IntervalYearMonthType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class IntervalYearMonthOperators {
    private IntervalYearMonthOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval year to month")
    public static long add(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        try {
            return Math.addExact((int)left, (int)right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Overflow adding interval year-month values: " + left + " + " + right);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval year to month")
    public static long subtract(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        try {
            return Math.subtractExact((int)left, (int)right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Overflow subtracting interval year-month values: " + left + " - " + right);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long multiplyByInteger(@SqlType(value="interval year to month") long left, @SqlType(value="integer") long right) {
        try {
            return Math.multiplyExact((int)left, (int)right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Overflow multiplying interval year-month value by integer: " + left + " * " + right);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long multiplyByDouble(@SqlType(value="interval year to month") long left, @SqlType(value="double") double right) {
        long result = (long)((double)left * right);
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Overflow multiplying interval year-month value by double: " + left + " * " + right);
        }
        return result;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long integerMultiply(@SqlType(value="integer") long left, @SqlType(value="interval year to month") long right) {
        try {
            return Math.multiplyExact((int)left, (int)right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Overflow multiplying integer by interval year-month value: " + left + " * " + right);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval year to month") long right) {
        long result = (long)(left * (double)right);
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Overflow multiplying double by interval year-month value: " + left + " * " + right);
        }
        return result;
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval year to month")
    public static long divideByDouble(@SqlType(value="interval year to month") long left, @SqlType(value="double") double right) {
        long result = (long)((double)left / right);
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Overflow dividing interval year-month value by double: " + left + " / " + right);
        }
        return result;
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval year to month")
    public static long negate(@SqlType(value="interval year to month") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="interval year to month") long value, @SqlType(value="interval year to month") long min, @SqlType(value="interval year to month") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(@SqlType(value="interval year to month") long value) {
        return Slices.utf8Slice((String)IntervalYearMonth.formatMonths((int)Math.toIntExact(value)));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="interval year to month") long value) {
        return AbstractIntType.hash((int)((int)value));
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="interval year to month") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class IntervalYearMonthDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="interval year to month") long left, @IsNull boolean leftNull, @SqlType(value="interval year to month") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return IntervalYearMonthOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="interval year to month", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="interval year to month", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return IntervalYearMonthOperators.notEqual(IntervalYearMonthType.INTERVAL_YEAR_MONTH.getLong(left, leftPosition), IntervalYearMonthType.INTERVAL_YEAR_MONTH.getLong(right, rightPosition));
        }
    }
}

