/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.AbstractIntType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;

@Deprecated
public final class LegacyRealComparisonOperators {
    private LegacyRealComparisonOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) == Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) != Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) < Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) <= Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) > Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) >= Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="real") long value, @SqlType(value="real") long min, @SqlType(value="real") long max) {
        return Float.intBitsToFloat((int)min) <= Float.intBitsToFloat((int)value) && Float.intBitsToFloat((int)value) <= Float.intBitsToFloat((int)max);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="real") long value) {
        return AbstractIntType.hash((int)Float.floatToIntBits(Float.intBitsToFloat((int)value)));
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class RealDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="real") long left, @IsNull boolean leftNull, @SqlType(value="real") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            float leftFloat = Float.intBitsToFloat((int)left);
            float rightFloat = Float.intBitsToFloat((int)right);
            if (Float.isNaN(leftFloat) && Float.isNaN(rightFloat)) {
                return false;
            }
            return LegacyRealComparisonOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="real", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="real", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return LegacyRealComparisonOperators.notEqual(RealType.REAL.getLong(left, leftPosition), RealType.REAL.getLong(right, rightPosition));
        }
    }
}

