/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.math.RoundingMode;

public final class RealOperators {
    private static final float MIN_LONG_AS_FLOAT = -9.223372E18f;
    private static final float MAX_LONG_PLUS_ONE_AS_FLOAT = 9.223372E18f;
    private static final float MIN_INTEGER_AS_FLOAT = -2.1474836E9f;
    private static final float MAX_INTEGER_PLUS_ONE_AS_FLOAT = 2.1474836E9f;
    private static final float MIN_SHORT_AS_FLOAT = -32768.0f;
    private static final float MAX_SHORT_PLUS_ONE_AS_FLOAT = 32768.0f;
    private static final float MIN_BYTE_AS_FLOAT = -128.0f;
    private static final float MAX_BYTE_PLUS_ONE_AS_FLOAT = 128.0f;

    private RealOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="real")
    public static long add(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) + Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="real")
    public static long subtract(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) - Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="real")
    public static long multiply(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) * Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="real")
    public static long divide(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) / Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="real")
    public static long modulus(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) % Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="real")
    public static long negate(@SqlType(value="real") long value) {
        return Float.floatToRawIntBits(-Float.intBitsToFloat((int)value));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="real") long value) {
        return XxHash64.hash((long)Float.floatToIntBits(Float.intBitsToFloat((int)value)));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="real") long value) {
        return Slices.utf8Slice((String)String.valueOf(Float.intBitsToFloat((int)value)));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToLong(@SqlType(value="real") long value) {
        try {
            return DoubleMath.roundToLong((double)Float.intBitsToFloat((int)value), (RoundingMode)RoundingMode.HALF_UP);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Unable to cast %s to bigint", Float.valueOf(Float.intBitsToFloat((int)value))), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="real") long value) {
        try {
            return DoubleMath.roundToInt((double)Float.intBitsToFloat((int)value), (RoundingMode)RoundingMode.HALF_UP);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Unable to cast %s to integer", Float.valueOf(Float.intBitsToFloat((int)value))), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="real") long value) {
        try {
            return Shorts.checkedCast((long)DoubleMath.roundToInt((double)Float.intBitsToFloat((int)value), (RoundingMode)RoundingMode.HALF_UP));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Unable to cast %s to smallint", Float.valueOf(Float.intBitsToFloat((int)value))), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="real") long value) {
        try {
            return SignedBytes.checkedCast((long)DoubleMath.roundToInt((double)Float.intBitsToFloat((int)value), (RoundingMode)RoundingMode.HALF_UP));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Unable to cast %s to tinyint", Float.valueOf(Float.intBitsToFloat((int)value))), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="real") long value) {
        return Float.intBitsToFloat((int)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="real") long value) {
        return Float.intBitsToFloat((int)value) != 0.0f;
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="smallint")
    public static long saturatedFloorCastToSmallint(@SqlType(value="real") long value) {
        return RealOperators.saturatedFloorCastToLong(value, -32768L, -32768.0f, 32767L, 32768.0f);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="tinyint")
    public static long saturatedFloorCastToTinyint(@SqlType(value="real") long value) {
        return RealOperators.saturatedFloorCastToLong(value, -128L, -128.0f, 127L, 128.0f);
    }

    private static long saturatedFloorCastToLong(long valueBits, long minValue, float minValueAsDouble, long maxValue, float maxValuePlusOneAsDouble) {
        float value = Float.intBitsToFloat((int)valueBits);
        if (value <= minValueAsDouble) {
            return minValue;
        }
        if (value + 1.0f >= maxValuePlusOneAsDouble) {
            return maxValue;
        }
        return DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="real") long value, @IsNull boolean isNull) {
        return isNull;
    }
}

