/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.type.ParameterKind;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;

public final class RowParametricType
implements ParametricType {
    public static final RowParametricType ROW = new RowParametricType();

    private RowParametricType() {
    }

    public String getName() {
        return "row";
    }

    public Type createType(List<TypeParameter> parameters) {
        Preconditions.checkArgument((!parameters.isEmpty() ? 1 : 0) != 0, (Object)"Row type must have at least one parameter");
        Preconditions.checkArgument((boolean)parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.NAMED_TYPE), (String)"Expected only named types as a parameters, got %s", parameters);
        List fields = parameters.stream().map(TypeParameter::getNamedType).map(parameter -> new RowType.Field(parameter.getName().map(RowFieldName::getName), parameter.getType(), parameter.getName().map(RowFieldName::isDelimited).orElse(false).booleanValue())).collect(Collectors.toList());
        return RowType.from(fields);
    }
}

