/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.sql.analyzer.MetadataHandle;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TableColumnMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MetadataUtils {
    private MetadataUtils() {
    }

    public static TableColumnMetadata getTableColumnsMetadata(Session session, MetadataResolver metadataResolver, MetadataHandle metadataHandle, QualifiedObjectName tableName) {
        if (metadataHandle.isPreProcessMetadataCalls()) {
            return metadataHandle.getTableColumnsMetadata(tableName);
        }
        return MetadataUtils.getTableColumnMetadata(session, metadataResolver, tableName);
    }

    public static Optional<ViewDefinition> getViewDefinition(Session session, MetadataResolver metadataResolver, MetadataHandle metadataHandle, QualifiedObjectName viewName) {
        if (metadataHandle.isPreProcessMetadataCalls()) {
            return metadataHandle.getViewDefinition(viewName);
        }
        return (Optional)session.getRuntimeStats().recordWallTime("getViewTimeNanos", () -> metadataResolver.getView(viewName));
    }

    public static Optional<MaterializedViewDefinition> getMaterializedViewDefinition(Session session, MetadataResolver metadataResolver, MetadataHandle metadataHandle, QualifiedObjectName viewName) {
        if (metadataHandle.isPreProcessMetadataCalls()) {
            return metadataHandle.getMaterializedViewDefinition(viewName);
        }
        return (Optional)session.getRuntimeStats().recordWallTime("getMaterializedViewTimeNanos", () -> metadataResolver.getMaterializedView(viewName));
    }

    public static TableColumnMetadata getTableColumnMetadata(Session session, MetadataResolver metadataResolver, QualifiedObjectName tableName) {
        Optional tableHandle = (Optional)session.getRuntimeStats().recordWallTime("getTableHandleTimeNanos", () -> metadataResolver.getTableHandle(tableName));
        if (!tableHandle.isPresent()) {
            if (!metadataResolver.catalogExists(tableName.getCatalogName())) {
                throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, "Catalog %s does not exist", new Object[]{tableName.getCatalogName()});
            }
            if (!metadataResolver.schemaExists(new CatalogSchemaName(tableName.getCatalogName(), tableName.getSchemaName()))) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, "Schema %s does not exist", new Object[]{tableName.getSchemaName()});
            }
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, "Table %s does not exist", new Object[]{tableName});
        }
        Map columnHandles = (Map)session.getRuntimeStats().recordWallTime("getColumnHandleTimeNanos", () -> metadataResolver.getColumnHandles((TableHandle)tableHandle.get()));
        List columnsMetadata = (List)session.getRuntimeStats().recordWallTime("getColumnMetadataTimeNanos", () -> metadataResolver.getColumns((TableHandle)tableHandle.get()));
        return new TableColumnMetadata(tableHandle, columnHandles, columnsMetadata);
    }
}

