/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.collect.ImmutableList;
import java.util.List;

public class StringTableUtils {
    private StringTableUtils() {
    }

    public static String getShortestTableStringFormat(List<List<String>> table) {
        if (table.isEmpty()) {
            throw new IllegalArgumentException("Table must include at least one row");
        }
        int tableWidth = table.get(0).size();
        int[] lengthTracker = new int[tableWidth];
        for (List<String> row : table) {
            if (row.size() != tableWidth) {
                String errorString = String.format("All rows in the table are expected to have exactly same number of columns: %s != %s", tableWidth, row.size());
                throw new IllegalArgumentException(errorString);
            }
            for (int i = 0; i < row.size(); ++i) {
                lengthTracker[i] = Math.max(row.get(i).length(), lengthTracker[i]);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append('|');
        for (int maxLen : lengthTracker) {
            sb.append(" %-").append(maxLen).append("s |");
        }
        return sb.toString();
    }

    public static List<String> getTableStrings(List<List<String>> table) {
        String formatString = StringTableUtils.getShortestTableStringFormat(table);
        return (List)table.stream().map(List::toArray).map(line -> String.format(formatString, line)).collect(ImmutableList.toImmutableList());
    }
}

