/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

@ThriftEnum
public enum QueryState {
    QUEUED(false, 1),
    WAITING_FOR_RESOURCES(false, 2),
    DISPATCHING(false, 3),
    PLANNING(false, 4),
    STARTING(false, 5),
    RUNNING(false, 6),
    FINISHING(false, 7),
    FINISHED(true, 8),
    FAILED(true, 9);

    public static final Set<QueryState> TERMINAL_QUERY_STATES;
    private final boolean doneState;
    private final int value;

    private QueryState(boolean doneState, int value) {
        this.doneState = doneState;
        this.value = value;
    }

    public boolean isDone() {
        return this.doneState;
    }

    @ThriftEnumValue
    public int getValue() {
        return this.value;
    }

    static {
        TERMINAL_QUERY_STATES = (Set)Stream.of(QueryState.values()).filter(QueryState::isDone).collect(ImmutableSet.toImmutableSet());
    }
}

