/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.ExceededCpuLimitException;
import com.facebook.presto.ExceededOutputSizeLimitException;
import com.facebook.presto.ExceededScanLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryManagerStats;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryTracker;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.warnings.WarningCollectorFactory;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.version.EmbedVersion;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class SqlQueryManager
implements QueryManager {
    private static final Logger log = Logger.get(SqlQueryManager.class);
    private final ClusterMemoryManager memoryManager;
    private final QueryMonitor queryMonitor;
    private final EmbedVersion embedVersion;
    private final QueryTracker<QueryExecution> queryTracker;
    private final Duration maxQueryCpuTime;
    private final DataSize maxQueryScanPhysicalBytes;
    private final DataSize maxQueryOutputSize;
    private final ScheduledExecutorService queryManagementExecutor;
    private final ThreadPoolExecutorMBean queryManagementExecutorMBean;
    private final QueryManagerStats stats = new QueryManagerStats();

    @Inject
    public SqlQueryManager(ClusterMemoryManager memoryManager, QueryMonitor queryMonitor, EmbedVersion embedVersion, QueryManagerConfig queryManagerConfig, WarningCollectorFactory warningCollectorFactory) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.embedVersion = Objects.requireNonNull(embedVersion, "embedVersion is null");
        this.maxQueryCpuTime = queryManagerConfig.getQueryMaxCpuTime();
        this.maxQueryScanPhysicalBytes = queryManagerConfig.getQueryMaxScanRawInputBytes();
        this.maxQueryOutputSize = queryManagerConfig.getQueryMaxOutputSize();
        this.queryManagementExecutor = Executors.newScheduledThreadPool(queryManagerConfig.getQueryManagerExecutorPoolSize(), Threads.threadsNamed((String)"query-management-%s"));
        this.queryManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.queryManagementExecutor));
        this.queryTracker = new QueryTracker(queryManagerConfig, this.queryManagementExecutor);
    }

    @PostConstruct
    public void start() {
        this.queryTracker.start();
        this.queryManagementExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.enforceMemoryLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing memory limits");
            }
            try {
                this.enforceCpuLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing query CPU time limits");
            }
            try {
                this.enforceScanLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing query scan bytes limits");
            }
            try {
                this.enforceOutputSizeLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing query output size limits");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryTracker.stop();
        this.queryManagementExecutor.shutdownNow();
    }

    @Override
    public List<BasicQueryInfo> getQueries() {
        return (List)this.queryTracker.getAllQueries().stream().map(queryExecution -> {
            try {
                return queryExecution.getBasicQueryInfo();
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void addOutputInfoListener(QueryId queryId, Consumer<QueryExecution.QueryOutputInfo> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.queryTracker.getQuery(queryId).addOutputInfoListener(listener);
    }

    @Override
    public void addStateChangeListener(QueryId queryId, StateMachine.StateChangeListener<QueryState> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.queryTracker.getQuery(queryId).addStateChangeListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryId queryId, QueryState currentState) {
        return this.queryTracker.tryGetQuery(queryId).map(query -> query.getStateChange(currentState)).orElseGet(() -> Futures.immediateFailedFuture((Throwable)new NoSuchElementException()));
    }

    @Override
    public BasicQueryInfo getQueryInfo(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getBasicQueryInfo();
    }

    @Override
    public QueryInfo getFullQueryInfo(QueryId queryId) throws NoSuchElementException {
        return this.queryTracker.getQuery(queryId).getQueryInfo();
    }

    @Override
    public Session getQuerySession(QueryId queryId) throws NoSuchElementException {
        return this.queryTracker.getQuery(queryId).getSession();
    }

    @Override
    public boolean isQuerySlugValid(QueryId queryId, String slug) {
        return this.queryTracker.getQuery(queryId).getSlug().equals(slug);
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getQueryPlan();
    }

    public void addFinalQueryInfoListener(QueryId queryId, StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.queryTracker.getQuery(queryId).addFinalQueryInfoListener(stateChangeListener);
    }

    @Override
    public QueryState getQueryState(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getState();
    }

    @Override
    public void recordHeartbeat(QueryId queryId) {
        this.queryTracker.tryGetQuery(queryId).ifPresent(QueryExecution::recordHeartbeat);
    }

    @Override
    public void createQuery(QueryExecution queryExecution) {
        Objects.requireNonNull(queryExecution, "queryExecution is null");
        if (!this.queryTracker.addQuery(queryExecution)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Query %s already registered", queryExecution.getQueryId()));
        }
        queryExecution.addFinalQueryInfoListener(finalQueryInfo -> {
            try {
                this.queryMonitor.queryCompletedEvent((QueryInfo)finalQueryInfo);
            }
            finally {
                this.queryTracker.expireQuery(queryExecution.getQueryId());
            }
        });
        this.stats.trackQueryStats(queryExecution);
        this.embedVersion.embedVersion(queryExecution::start).run();
    }

    @Override
    public void failQuery(QueryId queryId, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.queryTracker.tryGetQuery(queryId).ifPresent(query -> query.fail(cause));
    }

    @Override
    public void cancelQuery(QueryId queryId) {
        log.debug("Cancel query %s", new Object[]{queryId});
        this.queryTracker.tryGetQuery(queryId).ifPresent(QueryExecution::cancelQuery);
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        log.debug("Cancel stage %s", new Object[]{stageId});
        this.queryTracker.tryGetQuery(stageId.getQueryId()).ifPresent(query -> query.cancelStage(stageId));
    }

    @Override
    @Managed
    @Flatten
    public QueryManagerStats getStats() {
        return this.stats;
    }

    @Managed(description="Query management executor")
    @Nested
    public ThreadPoolExecutorMBean getManagementExecutor() {
        return this.queryManagementExecutorMBean;
    }

    @Managed
    public long getRunningTaskCount() {
        return this.queryTracker.getRunningTaskCount();
    }

    @Managed
    public long getQueriesKilledDueToTooManyTask() {
        return this.queryTracker.getQueriesKilledDueToTooManyTask();
    }

    private void enforceMemoryLimits() {
        List runningQueries = (List)this.queryTracker.getAllQueries().stream().filter(query -> query.getState() == QueryState.RUNNING).collect(ImmutableList.toImmutableList());
        this.memoryManager.process(runningQueries, this::getQueries);
    }

    private void enforceCpuLimits() {
        for (QueryExecution query : this.queryTracker.getAllQueries()) {
            Duration cpuTime = query.getTotalCpuTime();
            Duration sessionLimit = SystemSessionProperties.getQueryMaxCpuTime(query.getSession());
            Duration limit = (Duration)Ordering.natural().min((Object)this.maxQueryCpuTime, (Object)sessionLimit);
            if (cpuTime.compareTo(limit) <= 0) continue;
            query.fail((Throwable)((Object)new ExceededCpuLimitException(limit)));
        }
    }

    private void enforceScanLimits() {
        for (QueryExecution query : this.queryTracker.getAllQueries()) {
            DataSize rawInputSize = query.getRawInputDataSize();
            DataSize sessionlimit = SystemSessionProperties.getQueryMaxScanRawInputBytes(query.getSession());
            DataSize limit = (DataSize)Ordering.natural().min((Object)this.maxQueryScanPhysicalBytes, (Object)sessionlimit);
            if (rawInputSize.compareTo(limit) < 0) continue;
            query.fail((Throwable)((Object)new ExceededScanLimitException(limit)));
        }
    }

    private void enforceOutputSizeLimits() {
        for (QueryExecution query : this.queryTracker.getAllQueries()) {
            DataSize outputSize = query.getOutputDataSize();
            DataSize sessionlimit = SystemSessionProperties.getQueryMaxOutputSize(query.getSession());
            DataSize limit = (DataSize)Ordering.natural().min((Object)this.maxQueryOutputSize, (Object)sessionlimit);
            if (outputSize.compareTo(limit) < 0) continue;
            query.fail((Throwable)((Object)new ExceededOutputSizeLimitException(limit)));
        }
    }
}

