/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.airlift.concurrent.ExtendedSettableFuture;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.buffer.ArbitraryOutputBuffer;
import com.facebook.presto.execution.buffer.BroadcastOutputBuffer;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.DiscardingOutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.PartitionedOutputBuffer;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class LazyOutputBuffer
implements OutputBuffer {
    private final StateMachine<BufferState> state;
    private final String taskInstanceId;
    private final DataSize maxBufferSize;
    private final Supplier<LocalMemoryContext> systemMemoryContextSupplier;
    private final Executor executor;
    @GuardedBy(value="this")
    private volatile OutputBuffer delegate;
    @GuardedBy(value="this")
    private final Set<OutputBuffers.OutputBufferId> abortedBuffers = new HashSet<OutputBuffers.OutputBufferId>();
    @GuardedBy(value="this")
    private final List<PendingRead> pendingReads = new ArrayList<PendingRead>();

    public LazyOutputBuffer(TaskId taskId, String taskInstanceId, Executor executor, DataSize maxBufferSize, Supplier<LocalMemoryContext> systemMemoryContextSupplier) {
        Objects.requireNonNull(taskId, "taskId is null");
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.state = new StateMachine<BufferState>(taskId + "-buffer", executor, BufferState.OPEN, BufferState.TERMINAL_BUFFER_STATES);
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        Preconditions.checkArgument((maxBufferSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxBufferSize must be at least 1");
        this.systemMemoryContextSupplier = Objects.requireNonNull(systemMemoryContextSupplier, "systemMemoryContextSupplier is null");
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        if (outputBuffer == null) {
            return 1.0;
        }
        return outputBuffer.getUtilization();
    }

    @Override
    public boolean isOverutilized() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        return outputBuffer != null && outputBuffer.isOverutilized();
    }

    @Override
    public OutputBufferInfo getInfo() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        if (outputBuffer == null) {
            BufferState state = this.state.get();
            return new OutputBufferInfo("UNINITIALIZED", state, state.canAddBuffers(), state.canAddPages(), 0L, 0L, 0L, 0L, (List<BufferInfo>)ImmutableList.of());
        }
        return outputBuffer.getInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        ImmutableSet abortedBuffers = ImmutableSet.of();
        ImmutableList pendingReads = ImmutableList.of();
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                outputBuffer = this.delegate;
                if (outputBuffer == null) {
                    if (this.state.get().isTerminal()) {
                        return;
                    }
                    switch (newOutputBuffers.getType()) {
                        case PARTITIONED: {
                            outputBuffer = new PartitionedOutputBuffer(this.taskInstanceId, this.state, newOutputBuffers, this.maxBufferSize, this.systemMemoryContextSupplier, this.executor);
                            break;
                        }
                        case BROADCAST: {
                            outputBuffer = new BroadcastOutputBuffer(this.taskInstanceId, this.state, this.maxBufferSize, this.systemMemoryContextSupplier, this.executor);
                            break;
                        }
                        case ARBITRARY: {
                            outputBuffer = new ArbitraryOutputBuffer(this.taskInstanceId, this.state, this.maxBufferSize, this.systemMemoryContextSupplier, this.executor);
                            break;
                        }
                        case DISCARDING: {
                            outputBuffer = new DiscardingOutputBuffer(newOutputBuffers, this.state);
                        }
                    }
                    abortedBuffers = ImmutableSet.copyOf(this.abortedBuffers);
                    this.abortedBuffers.clear();
                    pendingReads = ImmutableList.copyOf(this.pendingReads);
                    this.pendingReads.clear();
                    this.delegate = outputBuffer;
                }
            }
        }
        outputBuffer.setOutputBuffers(newOutputBuffers);
        abortedBuffers.forEach(outputBuffer::abort);
        for (PendingRead pendingRead : pendingReads) {
            pendingRead.process(outputBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    if (this.state.get() == BufferState.FINISHED) {
                        return Futures.immediateFuture((Object)BufferResult.emptyResults(this.taskInstanceId, 0L, true));
                    }
                    PendingRead pendingRead = new PendingRead(bufferId, token, maxSize);
                    this.pendingReads.add(pendingRead);
                    return pendingRead.getFutureResult();
                }
                outputBuffer = this.delegate;
            }
        }
        return outputBuffer.get(bufferId, token, maxSize);
    }

    @Override
    public void acknowledge(OutputBuffers.OutputBufferId bufferId, long token) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.acknowledge(bufferId, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    this.abortedBuffers.add(bufferId);
                    return;
                }
                outputBuffer = this.delegate;
            }
        }
        outputBuffer.abort(bufferId);
    }

    @Override
    public ListenableFuture<?> isFull() {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        return outputBuffer.isFull();
    }

    @Override
    public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.registerLifespanCompletionCallback(callback);
    }

    @Override
    public void enqueue(Lifespan lifespan, List<SerializedPage> pages) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.enqueue(lifespan, pages);
    }

    @Override
    public void enqueue(Lifespan lifespan, int partition, List<SerializedPage> pages) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.enqueue(lifespan, partition, pages);
    }

    @Override
    public void setNoMorePages() {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.setNoMorePages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ImmutableList pendingReads = ImmutableList.of();
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    if (!this.state.setIf(BufferState.FINISHED, state -> !state.isTerminal())) {
                        return;
                    }
                    pendingReads = ImmutableList.copyOf(this.pendingReads);
                    this.pendingReads.clear();
                }
                outputBuffer = this.delegate;
            }
        }
        if (outputBuffer == null) {
            for (PendingRead pendingRead : pendingReads) {
                pendingRead.getFutureResult().set((Object)BufferResult.emptyResults(this.taskInstanceId, 0L, true));
            }
            return;
        }
        outputBuffer.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail() {
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    this.state.setIf(BufferState.FAILED, state -> !state.isTerminal());
                    return;
                }
                outputBuffer = this.delegate;
            }
        }
        outputBuffer.fail();
    }

    @Override
    public void setNoMorePagesForLifespan(Lifespan lifespan) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.setNoMorePagesForLifespan(lifespan);
    }

    @Override
    public boolean isFinishedForLifespan(Lifespan lifespan) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        return outputBuffer.isFinishedForLifespan(lifespan);
    }

    @Override
    public long getPeakMemoryUsage() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        if (outputBuffer != null) {
            return outputBuffer.getPeakMemoryUsage();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OutputBuffer getDelegateOutputBuffer() {
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                outputBuffer = this.delegate;
            }
        }
        return outputBuffer;
    }

    private OutputBuffer getDelegateOutputBufferOrFail() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        Preconditions.checkState((outputBuffer != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
        return outputBuffer;
    }

    private static class PendingRead {
        private final OutputBuffers.OutputBufferId bufferId;
        private final long startingSequenceId;
        private final DataSize maxSize;
        private final ExtendedSettableFuture<BufferResult> futureResult = ExtendedSettableFuture.create();

        public PendingRead(OutputBuffers.OutputBufferId bufferId, long startingSequenceId, DataSize maxSize) {
            this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
            this.startingSequenceId = startingSequenceId;
            this.maxSize = Objects.requireNonNull(maxSize, "maxSize is null");
        }

        public ExtendedSettableFuture<BufferResult> getFutureResult() {
            return this.futureResult;
        }

        public void process(OutputBuffer delegate) {
            if (this.futureResult.isDone()) {
                return;
            }
            try {
                ListenableFuture<BufferResult> result = delegate.get(this.bufferId, this.startingSequenceId, this.maxSize);
                this.futureResult.setAsync(result);
            }
            catch (Exception e) {
                this.futureResult.setException((Throwable)e);
            }
        }
    }
}

