/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.metadata.InternalNode;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class NodeAssignmentStats {
    private final NodeTaskMap nodeTaskMap;
    private final Map<InternalNode, Integer> nodeTotalSplitCount;
    private final Map<String, PendingSplitInfo> stageQueuedSplitInfo;

    public NodeAssignmentStats(NodeTaskMap nodeTaskMap, NodeMap nodeMap, List<RemoteTask> existingTasks) {
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        int nodeMapSize = Objects.requireNonNull(nodeMap, "nodeMap is null").getNodesByHostAndPort().size();
        this.nodeTotalSplitCount = new HashMap<InternalNode, Integer>(nodeMapSize);
        this.stageQueuedSplitInfo = new HashMap<String, PendingSplitInfo>(nodeMapSize);
        for (RemoteTask task : existingTasks) {
            Preconditions.checkArgument((this.stageQueuedSplitInfo.put(task.getNodeId(), new PendingSplitInfo(task.getQueuedPartitionedSplitCount(), task.getUnacknowledgedPartitionedSplitCount())) == null ? 1 : 0) != 0, (Object)"A single stage may not have multiple tasks running on the same node");
        }
        if (existingTasks.size() < nodeMapSize) {
            Function<String, PendingSplitInfo> createEmptySplitInfo = ignored -> new PendingSplitInfo(0, 0);
            for (InternalNode node : nodeMap.getNodesByHostAndPort().values()) {
                this.stageQueuedSplitInfo.computeIfAbsent(node.getNodeIdentifier(), createEmptySplitInfo);
            }
        }
    }

    public int getTotalSplitCount(InternalNode node) {
        int nodeTotalSplits = this.nodeTotalSplitCount.computeIfAbsent(node, this.nodeTaskMap::getPartitionedSplitsOnNode);
        PendingSplitInfo stageInfo = this.stageQueuedSplitInfo.get(node.getNodeIdentifier());
        return nodeTotalSplits + (stageInfo == null ? 0 : stageInfo.getAssignedSplitCount());
    }

    public int getQueuedSplitCountForStage(InternalNode node) {
        PendingSplitInfo stageInfo = this.stageQueuedSplitInfo.get(node.getNodeIdentifier());
        return stageInfo == null ? 0 : stageInfo.getQueuedSplitCount();
    }

    public int getUnacknowledgedSplitCountForStage(InternalNode node) {
        PendingSplitInfo stageInfo = this.stageQueuedSplitInfo.get(node.getNodeIdentifier());
        return stageInfo == null ? 0 : stageInfo.getUnacknowledgedSplitCount();
    }

    public void addAssignedSplit(InternalNode node) {
        String nodeId = node.getNodeIdentifier();
        PendingSplitInfo stageInfo = this.stageQueuedSplitInfo.get(nodeId);
        if (stageInfo == null) {
            stageInfo = new PendingSplitInfo(0, 0);
            this.stageQueuedSplitInfo.put(nodeId, stageInfo);
        }
        stageInfo.addAssignedSplit();
    }

    private static final class PendingSplitInfo {
        private final int queuedSplitCount;
        private final int unacknowledgedSplitCount;
        private int assignedSplits;

        private PendingSplitInfo(int queuedSplitCount, int unacknowledgedSplitCount) {
            this.queuedSplitCount = queuedSplitCount;
            this.unacknowledgedSplitCount = unacknowledgedSplitCount;
        }

        public int getAssignedSplitCount() {
            return this.assignedSplits;
        }

        public int getQueuedSplitCount() {
            return this.queuedSplitCount + this.assignedSplits;
        }

        public int getUnacknowledgedSplitCount() {
            return this.unacknowledgedSplitCount + this.assignedSplits;
        }

        public void addAssignedSplit() {
            ++this.assignedSplits;
        }
    }
}

