/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SpillingUtils;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.Spiller;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.util.MergeSortedPages;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OrderByOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrder;
    private final int[] outputChannels;
    private final LocalMemoryContext revocableMemoryContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final PagesIndex pageIndex;
    private final List<Type> sourceTypes;
    private final boolean spillEnabled;
    private final Optional<SpillerFactory> spillerFactory;
    private final OrderingCompiler orderingCompiler;
    private Optional<Spiller> spiller = Optional.empty();
    private ListenableFuture<?> spillInProgress = Futures.immediateFuture(null);
    private Runnable finishMemoryRevoke = () -> {};
    private Iterator<Optional<Page>> sortedPages;
    private State state = State.NEEDS_INPUT;

    public OrderByOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, int expectedPositions, List<Integer> sortChannels, List<SortOrder> sortOrder, PagesIndex.Factory pagesIndexFactory, boolean spillEnabled, Optional<SpillerFactory> spillerFactory, OrderingCompiler orderingCompiler) {
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputChannels = Ints.toArray((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
        this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder, "sortOrder is null"));
        this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.revocableMemoryContext = operatorContext.localRevocableMemoryContext();
        this.pageIndex = pagesIndexFactory.newPagesIndex(sourceTypes, expectedPositions);
        this.spillEnabled = spillEnabled;
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        Preconditions.checkArgument((!spillEnabled || spillerFactory.isPresent() ? 1 : 0) != 0, (Object)"Spiller Factory is not present when spill is enabled");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (!this.spillInProgress.isDone()) {
            return;
        }
        SpillingUtils.checkSpillSucceeded(this.spillInProgress);
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
            if (this.revocableMemoryContext.getBytes() > 0L) {
                long currentRevocableBytes = this.revocableMemoryContext.getBytes();
                this.revocableMemoryContext.setBytes(0L);
                if (!this.localUserMemoryContext.trySetBytes(this.localUserMemoryContext.getBytes() + currentRevocableBytes)) {
                    this.revocableMemoryContext.setBytes(currentRevocableBytes);
                    SpillingUtils.checkSpillSucceeded(this.spillToDisk());
                    this.finishMemoryRevoke.run();
                }
            }
            this.pageIndex.sort(this.sortChannels, this.sortOrder);
            Iterator<Page> sortedPagesIndex = this.pageIndex.getSortedPages();
            List<WorkProcessor<Page>> spilledPages = this.getSpilledPages();
            this.sortedPages = spilledPages.isEmpty() ? Iterators.transform(sortedPagesIndex, Optional::of) : this.mergeSpilledAndMemoryPages(spilledPages, sortedPagesIndex).yieldingIterator();
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.state == State.NEEDS_INPUT ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        SpillingUtils.checkSpillSucceeded(this.spillInProgress);
        this.pageIndex.addPage(page);
        this.updateMemoryUsage();
    }

    @Override
    public Page getOutput() {
        SpillingUtils.checkSpillSucceeded(this.spillInProgress);
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        Verify.verify((this.sortedPages != null ? 1 : 0) != 0, (String)"sortedPages is null", (Object[])new Object[0]);
        if (!this.sortedPages.hasNext()) {
            this.state = State.FINISHED;
            return null;
        }
        Optional<Page> next = this.sortedPages.next();
        if (!next.isPresent()) {
            return null;
        }
        Page nextPage = next.get();
        Block[] blocks = new Block[this.outputChannels.length];
        for (int i = 0; i < this.outputChannels.length; ++i) {
            blocks[i] = nextPage.getBlock(this.outputChannels[i]);
        }
        return new Page(nextPage.getPositionCount(), blocks);
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        Verify.verify((this.state == State.NEEDS_INPUT || this.revocableMemoryContext.getBytes() == 0L ? 1 : 0) != 0, (String)"Cannot spill in state: %s", (Object)((Object)this.state));
        return this.spillToDisk();
    }

    private ListenableFuture<?> spillToDisk() {
        SpillingUtils.checkSpillSucceeded(this.spillInProgress);
        if (this.revocableMemoryContext.getBytes() == 0L) {
            Verify.verify((this.pageIndex.getPositionCount() == 0 || this.state == State.HAS_OUTPUT ? 1 : 0) != 0);
            this.finishMemoryRevoke = () -> {};
            return Futures.immediateFuture(null);
        }
        if (!this.spiller.isPresent()) {
            this.spiller = Optional.of(this.spillerFactory.get().create(this.sourceTypes, this.operatorContext.getSpillContext(), this.operatorContext.newAggregateSystemMemoryContext()));
        }
        this.pageIndex.sort(this.sortChannels, this.sortOrder);
        this.spillInProgress = this.spiller.get().spill(this.pageIndex.getSortedPages());
        this.finishMemoryRevoke = () -> {
            this.pageIndex.clear();
            this.updateMemoryUsage();
        };
        return this.spillInProgress;
    }

    @Override
    public void finishMemoryRevoke() {
        this.finishMemoryRevoke.run();
        this.finishMemoryRevoke = () -> {};
    }

    private List<WorkProcessor<Page>> getSpilledPages() {
        if (!this.spiller.isPresent()) {
            return ImmutableList.of();
        }
        return (List)this.spiller.get().getSpills().stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList());
    }

    private WorkProcessor<Page> mergeSpilledAndMemoryPages(List<WorkProcessor<Page>> spilledPages, Iterator<Page> sortedPagesIndex) {
        ImmutableList sortedStreams = ImmutableList.builder().addAll(spilledPages).add(WorkProcessor.fromIterator(sortedPagesIndex)).build();
        return MergeSortedPages.mergeSortedPages((List<WorkProcessor<Page>>)sortedStreams, this.orderingCompiler.compilePageWithPositionComparator(this.sourceTypes, this.sortChannels, this.sortOrder), this.sourceTypes, this.operatorContext.aggregateUserMemoryContext(), this.operatorContext.getDriverContext().getYieldSignal());
    }

    private void updateMemoryUsage() {
        if (this.spillEnabled && this.state == State.NEEDS_INPUT) {
            if (this.pageIndex.getPositionCount() == 0) {
                this.localUserMemoryContext.setBytes(this.pageIndex.getEstimatedSize().toBytes());
                this.revocableMemoryContext.setBytes(0L);
            } else {
                this.localUserMemoryContext.setBytes(0L);
                this.revocableMemoryContext.setBytes(this.pageIndex.getEstimatedSize().toBytes());
            }
        } else {
            this.revocableMemoryContext.setBytes(0L);
            if (!this.localUserMemoryContext.trySetBytes(this.pageIndex.getEstimatedSize().toBytes())) {
                this.pageIndex.compact();
                this.localUserMemoryContext.setBytes(this.pageIndex.getEstimatedSize().toBytes());
            }
        }
    }

    @Override
    public void close() {
        this.pageIndex.clear();
        this.sortedPages = null;
        this.spiller.ifPresent(Spiller::close);
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class OrderByOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final int expectedPositions;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final PagesIndex.Factory pagesIndexFactory;
        private final boolean spillEnabled;
        private final Optional<SpillerFactory> spillerFactory;
        private final OrderingCompiler orderingCompiler;
        private boolean closed;

        public OrderByOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> outputChannels, int expectedPositions, List<Integer> sortChannels, List<SortOrder> sortOrder, PagesIndex.Factory pagesIndexFactory, boolean spillEnabled, Optional<SpillerFactory> spillerFactory, OrderingCompiler orderingCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
            this.outputChannels = Objects.requireNonNull(outputChannels, "outputChannels is null");
            this.expectedPositions = expectedPositions;
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder, "sortOrder is null"));
            this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
            this.spillEnabled = spillEnabled;
            this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
            this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
            Preconditions.checkArgument((!spillEnabled || spillerFactory.isPresent() ? 1 : 0) != 0, (Object)"Spiller Factory is not present when spill is enabled");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, OrderByOperator.class.getSimpleName());
            return new OrderByOperator(operatorContext, this.sourceTypes, this.outputChannels, this.expectedPositions, this.sortChannels, this.sortOrder, this.pagesIndexFactory, this.spillEnabled, this.spillerFactory, this.orderingCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new OrderByOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.outputChannels, this.expectedPositions, this.sortChannels, this.sortOrder, this.pagesIndexFactory, this.spillEnabled, this.spillerFactory, this.orderingCompiler);
        }
    }
}

