/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.array.AdaptiveLongBigArray;
import com.facebook.presto.common.Page;
import com.facebook.presto.operator.InternalJoinFilterFunction;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.SyntheticAddress;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class StandardJoinFilterFunction
implements JoinFilterFunction {
    private static final Page EMPTY_PAGE = new Page(0);
    private final InternalJoinFilterFunction filterFunction;
    private final AdaptiveLongBigArray addresses;
    private final List<Page> pages;

    public StandardJoinFilterFunction(InternalJoinFilterFunction filterFunction, AdaptiveLongBigArray addresses, List<Page> pages) {
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction can not be null");
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.pages = ImmutableList.copyOf((Collection)Objects.requireNonNull(pages, "pages is null"));
    }

    @Override
    public boolean filter(int leftPosition, int rightPosition, Page rightPage) {
        long pageAddress = this.addresses.get(leftPosition);
        int pageIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int pagePosition = SyntheticAddress.decodePosition(pageAddress);
        return this.filterFunction.filter(pagePosition, this.pages.isEmpty() ? EMPTY_PAGE : this.pages.get(pageIndex), rightPosition, rightPage);
    }
}

