/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent;

import com.clearspring.analytics.stream.Counter;
import com.clearspring.analytics.stream.StreamSummary;
import com.clearspring.analytics.util.ListNode2;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentBucketDeserializer;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentBucketSerializer;
import com.facebook.presto.operator.aggregation.approxmostfrequent.BucketConsumer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class ApproximateMostFrequentHistogram<K> {
    private static final byte FORMAT_TAG = 0;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ApproximateMostFrequentHistogram.class).instanceSize();
    private static final int STREAM_SUMMARY_SIZE = ClassLayout.parseClass(StreamSummary.class).instanceSize();
    private static final int LIST_NODE2_SIZE = ClassLayout.parseClass(ListNode2.class).instanceSize();
    private static final int COUNTER_SIZE = ClassLayout.parseClass(Counter.class).instanceSize();
    private final StreamSummary<K> streamSummary;
    private final int maxBuckets;
    private final int capacity;
    private final ApproximateMostFrequentBucketSerializer<K> serializer;
    private final ApproximateMostFrequentBucketDeserializer<K> deserializer;

    public ApproximateMostFrequentHistogram(int maxBuckets, int capacity, ApproximateMostFrequentBucketSerializer<K> serializer, ApproximateMostFrequentBucketDeserializer<K> deserializer) {
        Objects.requireNonNull(serializer, "serializer is null");
        Objects.requireNonNull(deserializer, "deserializer is null");
        this.streamSummary = new StreamSummary(capacity);
        this.maxBuckets = maxBuckets;
        this.capacity = capacity;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public ApproximateMostFrequentHistogram(Slice serialized, ApproximateMostFrequentBucketSerializer<K> serializer, ApproximateMostFrequentBucketDeserializer<K> deserializer) {
        BasicSliceInput input = serialized.getInput();
        Preconditions.checkArgument((input.readByte() == 0 ? 1 : 0) != 0, (Object)"Unsupported format tag");
        this.maxBuckets = input.readInt();
        this.capacity = input.readInt();
        int bucketSize = input.readInt();
        this.streamSummary = new StreamSummary(this.capacity);
        this.serializer = serializer;
        this.deserializer = deserializer;
        for (int i = 0; i < bucketSize; ++i) {
            this.deserializer.deserialize((SliceInput)input, this);
        }
    }

    public void add(K value) {
        this.streamSummary.offer(value);
    }

    public void add(K value, long incrementCount) {
        this.streamSummary.offer(value, Math.toIntExact(incrementCount));
    }

    public Slice serialize() {
        List counters = this.streamSummary.topK(this.maxBuckets);
        int estimatedSliceSize = 13 + counters.size() * 8 * 2;
        DynamicSliceOutput output = new DynamicSliceOutput(estimatedSliceSize);
        output.appendByte(0);
        output.appendInt(this.maxBuckets);
        output.appendInt(this.capacity);
        output.appendInt(counters.size());
        for (Counter counter : counters) {
            this.serializer.serialize(counter.getItem(), counter.getCount(), output);
        }
        return output.slice();
    }

    public void merge(ApproximateMostFrequentHistogram<K> other) {
        List counters = other.streamSummary.topK(this.maxBuckets);
        for (Counter counter : counters) {
            this.add(counter.getItem(), counter.getCount());
        }
    }

    public void forEachBucket(BucketConsumer<K> consumer) {
        List counters = this.streamSummary.topK(this.maxBuckets);
        for (Counter counter : counters) {
            consumer.process(counter.getItem(), counter.getCount());
        }
    }

    @VisibleForTesting
    public Map<K, Long> getBuckets() {
        ImmutableMap.Builder buckets = new ImmutableMap.Builder();
        this.forEachBucket((arg_0, arg_1) -> ((ImmutableMap.Builder)buckets).put(arg_0, arg_1));
        return buckets.build();
    }

    public long estimatedInMemorySize() {
        return INSTANCE_SIZE + STREAM_SUMMARY_SIZE + this.streamSummary.size() * (LIST_NODE2_SIZE + COUNTER_SIZE + 8);
    }
}

