/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ArrayJoin
extends SqlScalarFunction {
    public static final ArrayJoin ARRAY_JOIN = new ArrayJoin();
    public static final ArrayJoinWithNullReplacement ARRAY_JOIN_WITH_NULL_REPLACEMENT = new ArrayJoinWithNullReplacement();
    private static final TypeSignature VARCHAR_TYPE_SIGNATURE = VarcharType.VARCHAR.getTypeSignature();
    private static final String FUNCTION_NAME = "array_join";
    private static final String DESCRIPTION = "Concatenates the elements of the given array using a delimiter and an optional string to replace nulls";
    private static final MethodHandle METHOD_HANDLE_STACK = Reflection.methodHandle(ArrayJoin.class, "arrayJoinStack", MethodHandle.class, Object.class, SqlFunctionProperties.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK = Reflection.methodHandle(ArrayJoin.class, "arrayJoinProvidedBlock", MethodHandle.class, SqlFunctionProperties.class, BlockBuilder.class, Block.class, Slice.class);
    private static final MethodHandle GET_BOOLEAN = Reflection.methodHandle(Type.class, "getBoolean", Block.class, Integer.TYPE);
    private static final MethodHandle GET_DOUBLE = Reflection.methodHandle(Type.class, "getDouble", Block.class, Integer.TYPE);
    private static final MethodHandle GET_LONG = Reflection.methodHandle(Type.class, "getLong", Block.class, Integer.TYPE);
    private static final MethodHandle GET_SLICE = Reflection.methodHandle(Type.class, "getSlice", Block.class, Integer.TYPE);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(ArrayJoin.class, "createState", new Class[0]);

    public ArrayJoin() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)FUNCTION_NAME), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"varchar"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"varchar")), false));
    }

    @UsedByGeneratedCode
    public static Object createState() {
        return new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        return ArrayJoin.specializeArrayJoin(boundVariables.getTypeVariables(), functionAndTypeManager, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE_STACK, METHOD_HANDLE_PROVIDED_BLOCK);
    }

    private static BuiltInScalarFunctionImplementation specializeArrayJoin(Map<String, Type> types, FunctionAndTypeManager functionAndTypeManager, List<Boolean> nullableArguments, MethodHandle methodHandleStack, MethodHandle methodHandleProvidedBlock) {
        Type type = types.get("T");
        List argumentProperties = (List)nullableArguments.stream().map(nullable -> nullable != false ? BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE) : BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)).collect(ImmutableList.toImmutableList());
        if (type instanceof UnknownType) {
            return new BuiltInScalarFunctionImplementation(false, argumentProperties, methodHandleStack.bindTo(null), Optional.of(STATE_FACTORY));
        }
        try {
            MethodHandle getter;
            BuiltInScalarFunctionImplementation castFunction = functionAndTypeManager.getBuiltInScalarFunctionImplementation(functionAndTypeManager.lookupCast(CastType.CAST, type.getTypeSignature(), VARCHAR_TYPE_SIGNATURE));
            Class elementType = type.getJavaType();
            if (elementType == Boolean.TYPE) {
                getter = GET_BOOLEAN;
            } else if (elementType == Double.TYPE) {
                getter = GET_DOUBLE;
            } else if (elementType == Long.TYPE) {
                getter = GET_LONG;
            } else if (elementType == Slice.class) {
                getter = GET_SLICE;
            } else {
                throw new UnsupportedOperationException("Unsupported type: " + elementType.getName());
            }
            MethodHandle cast = castFunction.getMethodHandle();
            if (cast.type().parameterArray()[0] != SqlFunctionProperties.class) {
                cast = MethodHandles.dropArguments(cast, 0, new Class[]{SqlFunctionProperties.class});
            }
            cast = MethodHandles.permuteArguments(cast, MethodType.methodType(Slice.class, cast.type().parameterArray()[1], cast.type().parameterArray()[0]), 1, 0);
            cast = MethodHandles.dropArguments(cast, 1, new Class[]{Integer.TYPE});
            cast = MethodHandles.dropArguments(cast, 1, new Class[]{Block.class});
            cast = MethodHandles.foldArguments(cast, getter.bindTo(type));
            MethodHandle targetStack = MethodHandles.insertArguments(methodHandleStack, 0, cast);
            MethodHandle targetProvidedBlock = MethodHandles.insertArguments(methodHandleProvidedBlock, 0, cast);
            return new BuiltInScalarFunctionImplementation((List<BuiltInScalarFunctionImplementation.ScalarImplementationChoice>)ImmutableList.of((Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(false, argumentProperties, BuiltInScalarFunctionImplementation.ReturnPlaceConvention.STACK, targetStack, Optional.of(STATE_FACTORY)), (Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(false, argumentProperties, BuiltInScalarFunctionImplementation.ReturnPlaceConvention.PROVIDED_BLOCKBUILDER, targetProvidedBlock, Optional.empty())));
        }
        catch (PrestoException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Input type %s not supported", type), (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice arrayJoinStack(MethodHandle castFunction, Object state, SqlFunctionProperties properties, Block arrayBlock, Slice delimiter) {
        return ArrayJoin.arrayJoinStack(castFunction, state, properties, arrayBlock, delimiter, null);
    }

    @UsedByGeneratedCode
    public static void arrayJoinProvidedBlock(MethodHandle castFunction, SqlFunctionProperties properties, BlockBuilder blockBuilder, Block arrayBlock, Slice delimiter) {
        ArrayJoin.arrayJoinProvidedBlock(castFunction, properties, blockBuilder, arrayBlock, delimiter, null);
    }

    @UsedByGeneratedCode
    public static Slice arrayJoinStack(MethodHandle castFunction, Object state, SqlFunctionProperties properties, Block arrayBlock, Slice delimiter, Slice nullReplacement) {
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(0);
        try {
            ArrayJoin.arrayJoinProvidedBlock(castFunction, properties, blockBuilder, arrayBlock, delimiter, nullReplacement);
        }
        catch (PrestoException e) {
            pageBuilder.declarePosition();
        }
        pageBuilder.declarePosition();
        return VarcharType.VARCHAR.getSlice((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }

    @UsedByGeneratedCode
    public static void arrayJoinProvidedBlock(MethodHandle castFunction, SqlFunctionProperties properties, BlockBuilder blockBuilder, Block arrayBlock, Slice delimiter, Slice nullReplacement) {
        int numElements = arrayBlock.getPositionCount();
        for (int i = 0; i < numElements; ++i) {
            if (arrayBlock.isNull(i)) {
                if (nullReplacement == null) continue;
                blockBuilder.writeBytes(nullReplacement, 0, nullReplacement.length());
            } else {
                try {
                    Slice slice = castFunction.invokeExact(arrayBlock, i, properties);
                    blockBuilder.writeBytes(slice, 0, slice.length());
                }
                catch (Throwable throwable) {
                    blockBuilder.closeEntry();
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error casting array element to VARCHAR", throwable);
                }
            }
            if (i == numElements - 1) continue;
            blockBuilder.writeBytes(delimiter, 0, delimiter.length());
        }
        blockBuilder.closeEntry();
    }

    public static class ArrayJoinWithNullReplacement
    extends SqlScalarFunction {
        private static final MethodHandle METHOD_HANDLE_STACK = Reflection.methodHandle(ArrayJoin.class, "arrayJoinStack", MethodHandle.class, Object.class, SqlFunctionProperties.class, Block.class, Slice.class, Slice.class);
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK = Reflection.methodHandle(ArrayJoin.class, "arrayJoinProvidedBlock", MethodHandle.class, SqlFunctionProperties.class, BlockBuilder.class, Block.class, Slice.class, Slice.class);

        public ArrayJoinWithNullReplacement() {
            super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)ArrayJoin.FUNCTION_NAME), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"varchar"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"varchar"), (Object)TypeSignature.parseTypeSignature((String)"varchar")), false));
        }

        public SqlFunctionVisibility getVisibility() {
            return SqlFunctionVisibility.PUBLIC;
        }

        public boolean isDeterministic() {
            return true;
        }

        public String getDescription() {
            return ArrayJoin.DESCRIPTION;
        }

        @Override
        public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
            return ArrayJoin.specializeArrayJoin(boundVariables.getTypeVariables(), functionAndTypeManager, (List)ImmutableList.of((Object)false, (Object)false, (Object)false), ArrayJoinWithNullReplacement.METHOD_HANDLE_STACK, ArrayJoinWithNullReplacement.METHOD_HANDLE_PROVIDED_BLOCK);
        }
    }
}

