/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.tdigest.Centroid;
import com.facebook.presto.tdigest.TDigest;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.List;

public final class TDigestFunctions {
    public static final double DEFAULT_COMPRESSION = 100.0;
    @VisibleForTesting
    static final RowType TDIGEST_CENTROIDS_ROW_TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"centroid_means", (Type)new ArrayType((Type)DoubleType.DOUBLE)), (Object)RowType.field((String)"centroid_weights", (Type)new ArrayType((Type)IntegerType.INTEGER)), (Object)RowType.field((String)"compression", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"min", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"max", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"sum", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"count", (Type)IntegerType.INTEGER)));

    private TDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantileDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double quantile) {
        return TDigest.createTDigest(input).getQuantile(quantile);
    }

    @ScalarFunction(value="values_at_quantiles", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantilesDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, tDigest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)));
        }
        return output.build();
    }

    @ScalarFunction(value="quantile_at_value", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Given an input x between min/max values of t-digest, find which quantile is represented by that value")
    @SqlType(value="double")
    public static double quantileAtValueDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double value) {
        return TDigest.createTDigest(input).getCdf(value);
    }

    @ScalarFunction(value="quantiles_at_values", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="For each input x between min/max values of t-digest, find which quantile is represented by that value")
    @SqlType(value="array(double)")
    public static Block quantilesAtValuesDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="array(double)") Block valuesArrayBlock) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, valuesArrayBlock.getPositionCount());
        for (int i = 0; i < valuesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, tDigest.getCdf(DoubleType.DOUBLE.getDouble(valuesArrayBlock, i)));
        }
        return output.build();
    }

    @ScalarFunction(value="scale_tdigest", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Scale a t-digest according to a new weight")
    @SqlType(value="tdigest(double)")
    public static Slice scaleTDigestDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double scale) {
        Failures.checkCondition(scale > 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Scale factor should be positive.", new Object[0]);
        TDigest digest = TDigest.createTDigest(input);
        digest.scale(scale);
        return digest.serialize();
    }

    @ScalarFunction(value="destructure_tdigest", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Return the raw TDigest, including arrays of centroid means and weights, as well as min, max, sum, count, and compression factor.")
    @SqlType(value="row(centroid_means array(double), centroid_weights array(integer), compression double, min double, max double, sum double, count integer)")
    public static Block destructureTDigest(@SqlType(value="tdigest(double)") Slice input) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder blockBuilder = TDIGEST_CENTROIDS_ROW_TYPE.createBlockBuilder(null, 1);
        BlockBuilder rowBuilder = blockBuilder.beginBlockEntry();
        BlockBuilder meansBuilder = DoubleType.DOUBLE.createBlockBuilder(null, tDigest.centroidCount());
        BlockBuilder weightsBuilder = IntegerType.INTEGER.createBlockBuilder(null, tDigest.centroidCount());
        int count = 0;
        for (Centroid centroid : tDigest.centroids()) {
            int weight = centroid.getWeight();
            DoubleType.DOUBLE.writeDouble(meansBuilder, centroid.getMean());
            IntegerType.INTEGER.writeLong(weightsBuilder, (long)weight);
            count += weight;
        }
        rowBuilder.appendStructure((Block)meansBuilder);
        rowBuilder.appendStructure((Block)weightsBuilder);
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getCompressionFactor());
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getMin());
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getMax());
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getSum());
        IntegerType.INTEGER.writeLong(rowBuilder, (long)count);
        blockBuilder.closeEntry();
        return TDIGEST_CENTROIDS_ROW_TYPE.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }
}

