/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.Failures;

public class WilsonInterval {
    private WilsonInterval() {
    }

    @ScalarFunction
    @Description(value="binomial confidence interval lower bound using Wilson score")
    @SqlType(value="double")
    public static double wilsonIntervalLower(@SqlType(value="bigint") long successes, @SqlType(value="bigint") long trials, @SqlType(value="double") double z) {
        return WilsonInterval.wilsonInterval(successes, trials, z, -1);
    }

    @ScalarFunction
    @Description(value="binomial confidence interval upper bound using Wilson score")
    @SqlType(value="double")
    public static double wilsonIntervalUpper(@SqlType(value="bigint") long successes, @SqlType(value="bigint") long trials, @SqlType(value="double") double z) {
        return WilsonInterval.wilsonInterval(successes, trials, z, 1);
    }

    private static double wilsonInterval(long successes, long trials, double z, int bound) {
        Failures.checkCondition(successes >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "number of successes must not be negative", new Object[0]);
        Failures.checkCondition(trials > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "number of trials must be positive", new Object[0]);
        Failures.checkCondition(successes <= trials, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "number of successes must not be larger than number of trials", new Object[0]);
        Failures.checkCondition(z >= 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "z-score must not be negative", new Object[0]);
        double p = (double)successes * 1.0 / (double)trials;
        double n = trials;
        return (p + z * z / (2.0 * n) + (double)bound * z * Math.sqrt(p * (1.0 - p) / n + z * z / (4.0 * n * n))) / (1.0 + z * z / n);
    }
}

