/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.operator.unnest.UnnestBlockBuilder;
import com.facebook.presto.operator.unnest.Unnester;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class ArrayOfRowsUnnester
implements Unnester {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayOfRowsUnnester.class).instanceSize();
    private final int fieldCount;
    private final UnnestBlockBuilder[] unnestBlockBuilders;
    private int[] lengths = new int[0];
    private ColumnarArray columnarArray;
    private ColumnarRow columnarRow;

    public ArrayOfRowsUnnester(int fieldCount) {
        this.unnestBlockBuilders = ArrayOfRowsUnnester.createUnnestBlockBuilder(fieldCount);
        this.fieldCount = fieldCount;
    }

    @Override
    public int getChannelCount() {
        return this.fieldCount;
    }

    @Override
    public void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.columnarArray = ColumnarArray.toColumnarArray((Block)block);
        this.columnarRow = ColumnarRow.toColumnarRow((Block)this.columnarArray.getElementsBlock());
        for (int i = 0; i < this.fieldCount; ++i) {
            this.unnestBlockBuilders[i].resetInputBlock(this.columnarRow.getField(i), this.columnarRow.getNullCheckBlock());
        }
        int positionCount = block.getPositionCount();
        this.lengths = Arrays.ensureCapacity((int[])this.lengths, (int)positionCount);
        for (int j = 0; j < positionCount; ++j) {
            this.lengths[j] = this.columnarArray.getLength(j);
        }
    }

    @Override
    public int[] getLengths() {
        return this.lengths;
    }

    @Override
    public Block[] buildOutputBlocks(int[] maxLengths, int startPosition, int batchSize, int currentBatchTotalLength) {
        boolean nullRequired = this.needToInsertNulls(startPosition, batchSize, currentBatchTotalLength);
        Block[] outputBlocks = new Block[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            outputBlocks[i] = nullRequired ? this.unnestBlockBuilders[i].buildOutputBlockWithNulls(maxLengths, startPosition, batchSize, currentBatchTotalLength, this.lengths) : this.unnestBlockBuilders[i].buildOutputBlockWithoutNulls(currentBatchTotalLength);
        }
        return outputBlocks;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.lengths);
    }

    private static UnnestBlockBuilder[] createUnnestBlockBuilder(int fieldCount) {
        UnnestBlockBuilder[] builders = new UnnestBlockBuilder[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            builders[i] = new UnnestBlockBuilder();
        }
        return builders;
    }

    private boolean needToInsertNulls(int offset, int length, int currentBatchTotalLength) {
        int start = this.columnarArray.getOffset(offset);
        int end = this.columnarArray.getOffset(offset + length);
        int totalLength = end - start;
        if (totalLength < currentBatchTotalLength) {
            return true;
        }
        if (this.columnarRow.getNullCheckBlock().mayHaveNull()) {
            for (int i = start; i < end; ++i) {
                if (!this.columnarRow.isNull(i)) continue;
                return true;
            }
        }
        return false;
    }
}

