/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.facebook.drift.transport.netty.codec.Protocol;
import io.airlift.units.DataSize;
import java.util.Optional;

public class InternalCommunicationConfig {
    public static final String INTERNAL_COMMUNICATION_KERBEROS_ENABLED = "internal-communication.kerberos.enabled";
    private boolean httpsRequired;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;
    private Optional<String> excludeCipherSuites = Optional.empty();
    private Optional<String> includedCipherSuites = Optional.empty();
    private boolean kerberosEnabled;
    private boolean kerberosUseCanonicalHostname = true;
    private boolean binaryTransportEnabled;
    private boolean thriftTransportEnabled;
    private Protocol thriftProtocol = Protocol.BINARY;
    private DataSize maxTaskUpdateSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private CommunicationProtocol taskCommunicationProtocol = CommunicationProtocol.HTTP;
    private CommunicationProtocol serverInfoCommunicationProtocol = CommunicationProtocol.HTTP;

    public boolean isHttpsRequired() {
        return this.httpsRequired;
    }

    @Config(value="internal-communication.https.required")
    public InternalCommunicationConfig setHttpsRequired(boolean httpsRequired) {
        this.httpsRequired = httpsRequired;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="internal-communication.https.keystore.path")
    public InternalCommunicationConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="internal-communication.https.keystore.key")
    @ConfigSecuritySensitive
    public InternalCommunicationConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="internal-communication.https.trust-store-path")
    public InternalCommunicationConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="internal-communication.https.trust-store-password")
    public InternalCommunicationConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public Optional<String> getIncludedCipherSuites() {
        return this.includedCipherSuites;
    }

    @Config(value="internal-communication.https.included-cipher")
    public InternalCommunicationConfig setIncludedCipherSuites(String includedCipherSuites) {
        this.includedCipherSuites = Optional.ofNullable(includedCipherSuites);
        return this;
    }

    public Optional<String> getExcludeCipherSuites() {
        return this.excludeCipherSuites;
    }

    @Config(value="internal-communication.https.excluded-cipher")
    public InternalCommunicationConfig setExcludeCipherSuites(String excludeCipherSuites) {
        this.excludeCipherSuites = Optional.ofNullable(excludeCipherSuites);
        return this;
    }

    public boolean isKerberosEnabled() {
        return this.kerberosEnabled;
    }

    @Config(value="internal-communication.kerberos.enabled")
    public InternalCommunicationConfig setKerberosEnabled(boolean kerberosEnabled) {
        this.kerberosEnabled = kerberosEnabled;
        return this;
    }

    public boolean isKerberosUseCanonicalHostname() {
        return this.kerberosUseCanonicalHostname;
    }

    @Config(value="internal-communication.kerberos.use-canonical-hostname")
    public InternalCommunicationConfig setKerberosUseCanonicalHostname(boolean kerberosUseCanonicalHostname) {
        this.kerberosUseCanonicalHostname = kerberosUseCanonicalHostname;
        return this;
    }

    public boolean isBinaryTransportEnabled() {
        return this.binaryTransportEnabled;
    }

    @Config(value="experimental.internal-communication.binary-transport-enabled")
    @ConfigDescription(value="Enables smile encoding support for coordinator-to-worker communication")
    public InternalCommunicationConfig setBinaryTransportEnabled(boolean binaryTransportEnabled) {
        this.binaryTransportEnabled = binaryTransportEnabled;
        return this;
    }

    public boolean isThriftTransportEnabled() {
        return this.thriftTransportEnabled;
    }

    @Config(value="experimental.internal-communication.thrift-transport-enabled")
    @ConfigDescription(value="Enables thrift encoding support for internal communication")
    public InternalCommunicationConfig setThriftTransportEnabled(boolean thriftTransportEnabled) {
        this.thriftTransportEnabled = thriftTransportEnabled;
        return this;
    }

    public Protocol getThriftProtocol() {
        return this.thriftProtocol;
    }

    @Config(value="experimental.internal-communication.thrift-transport-protocol")
    @ConfigDescription(value="Thrift encoding type for internal communication")
    public InternalCommunicationConfig setThriftProtocol(Protocol thriftProtocol) {
        this.thriftProtocol = thriftProtocol;
        return this;
    }

    public DataSize getMaxTaskUpdateSize() {
        return this.maxTaskUpdateSize;
    }

    @Config(value="experimental.internal-communication.max-task-update-size")
    @ConfigDescription(value="Enables limit on the size of the task update")
    public InternalCommunicationConfig setMaxTaskUpdateSize(DataSize maxTaskUpdateSize) {
        this.maxTaskUpdateSize = maxTaskUpdateSize;
        return this;
    }

    public CommunicationProtocol getTaskCommunicationProtocol() {
        return this.taskCommunicationProtocol;
    }

    @Config(value="internal-communication.task-communication-protocol")
    @ConfigDescription(value="Set task communication protocol")
    public InternalCommunicationConfig setTaskCommunicationProtocol(CommunicationProtocol taskCommunicationProtocol) {
        this.taskCommunicationProtocol = taskCommunicationProtocol;
        return this;
    }

    public CommunicationProtocol getServerInfoCommunicationProtocol() {
        return this.serverInfoCommunicationProtocol;
    }

    @Config(value="internal-communication.server-info-communication-protocol")
    @ConfigDescription(value="Set server info communication protocol to broadcast state info")
    public InternalCommunicationConfig setServerInfoCommunicationProtocol(CommunicationProtocol serverInfoCommunicationProtocol) {
        this.serverInfoCommunicationProtocol = serverInfoCommunicationProtocol;
        return this;
    }

    public static enum CommunicationProtocol {
        HTTP,
        THRIFT;

    }
}

