/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import sun.misc.Unsafe;

public class SerializedPageWriteListener
implements WriteListener {
    private static final Logger log = Logger.get(SerializedPageWriteListener.class);
    public static final int PAGE_METADATA_SIZE = 13;
    private final ArrayDeque<SerializedPage> serializedPages;
    private final AsyncContext asyncContext;
    private final ServletOutputStream output;
    private final Slice slice;
    private SerializedPage page;

    public SerializedPageWriteListener(List<SerializedPage> serializedPages, AsyncContext asyncContext, ServletOutputStream output) {
        this.serializedPages = new ArrayDeque(Objects.requireNonNull(serializedPages, "serializedPages is null"));
        this.asyncContext = Objects.requireNonNull(asyncContext, "asyncContext is null");
        this.output = Objects.requireNonNull(output, "output is null");
        this.slice = Slices.allocate((int)13);
    }

    public void onWritePossible() throws IOException {
        while (this.output.isReady()) {
            if (this.writeComplete()) {
                this.asyncContext.complete();
                return;
            }
            if (this.page == null) {
                this.page = this.serializedPages.poll();
                int bufferPosition = 0;
                this.slice.setInt(bufferPosition, this.page.getPositionCount());
                this.slice.setByte(bufferPosition += 4, (int)this.page.getPageCodecMarkers());
                this.slice.setInt(++bufferPosition, this.page.getUncompressedSizeInBytes());
                this.slice.setInt(bufferPosition += 4, this.page.getSizeInBytes());
                this.output.write(this.slice.byteArray(), 0, bufferPosition += 4);
                continue;
            }
            Object base = this.page.getSlice().getBase();
            Preconditions.checkArgument((boolean)(base instanceof byte[]), (Object)"serialization type only supports byte[]");
            this.output.write((byte[])base, (int)(this.page.getSlice().getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), this.page.getSizeInBytes());
            this.page = null;
        }
    }

    public void onError(Throwable t) {
        log.error(t);
        this.asyncContext.complete();
    }

    private boolean writeComplete() {
        return this.serializedPages.isEmpty() && this.page == null;
    }
}

